/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Options;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private List resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    private void init() {
        this.resolvers = new ArrayList();
    }

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] stringArray = ResolverConfig.getCurrentConfig().servers();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                SimpleResolver simpleResolver = new SimpleResolver(stringArray[i]);
                simpleResolver.setTimeout(5);
                this.resolvers.add(simpleResolver);
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] stringArray) throws UnknownHostException {
        this.init();
        for (int i = 0; i < stringArray.length; ++i) {
            SimpleResolver simpleResolver = new SimpleResolver(stringArray[i]);
            simpleResolver.setTimeout(5);
            this.resolvers.add(simpleResolver);
        }
    }

    public ExtendedResolver(Resolver[] resolverArray) throws UnknownHostException {
        this.init();
        for (int i = 0; i < resolverArray.length; ++i) {
            this.resolvers.add(resolverArray[i]);
        }
    }

    @Override
    public void setPort(int n) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setPort(n);
        }
    }

    @Override
    public void setTCP(boolean bl) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTCP(bl);
        }
    }

    @Override
    public void setIgnoreTruncation(boolean bl) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setIgnoreTruncation(bl);
        }
    }

    @Override
    public void setEDNS(int n) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(n);
        }
    }

    @Override
    public void setEDNS(int n, int n2, int n3, List list) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(n, n2, n3, list);
        }
    }

    @Override
    public void setTSIGKey(TSIG tSIG) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(tSIG);
        }
    }

    @Override
    public void setTimeout(int n, int n2) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTimeout(n, n2);
        }
    }

    @Override
    public void setTimeout(int n) {
        this.setTimeout(n, 0);
    }

    @Override
    public Message send(Message message) throws IOException {
        Resolution resolution = new Resolution(this, message);
        return resolution.start();
    }

    @Override
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Resolution resolution = new Resolution(this, message);
        resolution.startAsync(resolverListener);
        return resolution;
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (Resolver)this.resolvers.get(n);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return this.resolvers.toArray(new Resolver[this.resolvers.size()]);
    }

    public void addResolver(Resolver resolver) {
        this.resolvers.add(resolver);
    }

    public void deleteResolver(Resolver resolver) {
        this.resolvers.remove(resolver);
    }

    public void setLoadBalance(boolean bl) {
        this.loadBalance = bl;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    private static class Resolution
    implements ResolverListener {
        Resolver[] resolvers;
        int[] sent;
        Object[] inprogress;
        int retries;
        int outstanding;
        boolean done;
        Message query;
        Message response;
        Throwable thrown;
        ResolverListener listener;

        public Resolution(ExtendedResolver extendedResolver, Message message) {
            List list = extendedResolver.resolvers;
            this.resolvers = list.toArray(new Resolver[list.size()]);
            if (extendedResolver.loadBalance) {
                int n = this.resolvers.length;
                int n2 = extendedResolver.lbStart++ % n;
                if (extendedResolver.lbStart > n) {
                    extendedResolver.lbStart %= n;
                }
                if (n2 > 0) {
                    Resolver[] resolverArray = new Resolver[n];
                    for (int i = 0; i < n; ++i) {
                        int n3 = (i + n2) % n;
                        resolverArray[i] = this.resolvers[n3];
                    }
                    this.resolvers = resolverArray;
                }
            }
            this.sent = new int[this.resolvers.length];
            this.inprogress = new Object[this.resolvers.length];
            this.retries = extendedResolver.retries;
            this.query = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(int n) {
            int n2 = n;
            this.sent[n2] = this.sent[n2] + 1;
            ++this.outstanding;
            try {
                this.inprogress[n] = this.resolvers[n].sendAsync(this.query, this);
            }
            catch (Throwable throwable) {
                Resolution resolution = this;
                synchronized (resolution) {
                    this.thrown = throwable;
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message start() throws IOException {
            try {
                this.sent[0] = this.sent[0] + 1;
                ++this.outstanding;
                this.inprogress[0] = new Object();
                return this.resolvers[0].send(this.query);
            }
            catch (Exception exception) {
                this.handleException(this.inprogress[0], exception);
                Resolution resolution = this;
                synchronized (resolution) {
                    while (!this.done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.response != null) {
                    return this.response;
                }
                if (this.thrown instanceof IOException) {
                    throw (IOException)this.thrown;
                }
                if (this.thrown instanceof RuntimeException) {
                    throw (RuntimeException)this.thrown;
                }
                if (this.thrown instanceof Error) {
                    throw (Error)this.thrown;
                }
                throw new IllegalStateException("ExtendedResolver failure");
            }
        }

        public void startAsync(ResolverListener resolverListener) {
            this.listener = resolverListener;
            this.send(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveMessage(Object object, Message message) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message");
            }
            Resolution resolution = this;
            synchronized (resolution) {
                if (this.done) {
                    return;
                }
                this.response = message;
                this.done = true;
                if (this.listener == null) {
                    this.notifyAll();
                    return;
                }
            }
            this.listener.receiveMessage(this, this.response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleException(Object object, Exception exception) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: got " + exception);
            }
            Resolution resolution = this;
            synchronized (resolution) {
                int n;
                --this.outstanding;
                if (this.done) {
                    return;
                }
                for (n = 0; n < this.inprogress.length && this.inprogress[n] != object; ++n) {
                }
                if (n == this.inprogress.length) {
                    return;
                }
                boolean bl = false;
                if (this.sent[n] == 1 && n < this.resolvers.length - 1) {
                    bl = true;
                }
                if (exception instanceof InterruptedIOException) {
                    if (this.sent[n] < this.retries) {
                        this.send(n);
                    }
                    if (this.thrown == null) {
                        this.thrown = exception;
                    }
                } else if (exception instanceof SocketException) {
                    if (this.thrown == null || this.thrown instanceof InterruptedIOException) {
                        this.thrown = exception;
                    }
                } else {
                    this.thrown = exception;
                }
                if (this.done) {
                    return;
                }
                if (bl) {
                    this.send(n + 1);
                }
                if (this.done) {
                    return;
                }
                if (this.outstanding == 0) {
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
                if (!this.done) {
                    return;
                }
            }
            if (!(this.thrown instanceof Exception)) {
                this.thrown = new RuntimeException(this.thrown.getMessage());
            }
            this.listener.handleException(this, (Exception)this.thrown);
        }
    }
}

