package com.beem.project.beem;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

/**
 *
 */
public class SettingsDialog extends Dialog implements android.view.View.OnClickListener {

    private Beem mbeem;
    private SharedPreferences mSettings;
    public SettingsDialog(Beem beem, SharedPreferences settings) {
        super(beem);
        this.mbeem = beem;
        this.mSettings = settings;
    }

    @Override
    protected void onStart() {
        super.onStart();
        setContentView(R.layout.settings);
        getWindow().setFlags(4, 4);
        setTitle("Jabber Account Settings");
        showSettings();
        Button ok = (Button) findViewById(R.id.ok);
        ok.setOnClickListener(this);
    }
    
    @Override
    public void onClick(View v) {
        SharedPreferences.Editor editor = mSettings.edit();
        Context ctx = getContext();
        editor.putString(ctx.getString(R.string.PreferenceHostKey), getWidgetText(R.id.host));
        editor.putString(ctx.getString(R.string.PreferencePortKey), getWidgetText(R.id.port));
        editor.putString(ctx.getString(R.string.PreferenceLoginKey), getWidgetText(R.id.userid));
        editor.putString(ctx.getString(R.string.PreferencePasswordKey), getWidgetText(R.id.password));
        editor.commit();
        this.mbeem.showJID();
        dismiss();
    }
    
    private void showSettings() {
        String tmp;
        EditText eHost = (EditText) findViewById(R.id.host);
        if ((tmp = mSettings.getString("host","")) != "")
            eHost.setText(tmp);
        EditText ePort = (EditText) findViewById(R.id.port);
        if ((tmp = mSettings.getString("port","")) != "")
            ePort.setText(tmp);
        EditText eLogin = (EditText) findViewById(R.id.userid);
        if ((tmp = mSettings.getString("login","")) != "")
            eLogin.setText(tmp);
        EditText ePwd = (EditText) findViewById(R.id.password);
        if ((tmp = mSettings.getString("password","")) != "")
            ePwd.setText(tmp);
    }
    
    private String getWidgetText(int id) {
        EditText widget = (EditText) this.findViewById(id);
        return widget.getText().toString();
    }
}
