package com.beem.project.beem.service.aidl;

import  com.beem.project.beem.service.Contact;
import  com.beem.project.beem.service.Message;
import  com.beem.project.beem.service.aidl.IMessageListener;

/**
 * An aidl interface for Chat session.
 */
interface IChat {
    
    	/**
    	 * Send a message.
    	 * @param message	the message to send
    	 */
	void sendMessage(in Message message);
	
	/**
	 * Get the participant of the chat
	 * @return the participant
	 */
	Contact getParticipant();
	
	String getState();
	
	void setState(in String state);
	
	String getLastMessages();
	
	void addToLastMessages(in String msg);
	
	void clearLastMessages();
/*	
	void addMessageListener(in IMessageListener listener);
	
	void removeMessageListener(in IMessageListener listener);
*/	
}