package com.beem.project.beem.ui;

import android.app.Activity;
import android.os.Bundle;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.view.animation.AnimationUtils;
import com.beem.project.beem.R;

/**
 * This class is an activity which display an animation during the connection
 * with the server.
 * @author Da Risk <darisk972@gmail.com>
 */
public class LoginAnim extends Activity {

    private ImageView mLogo;
    private Animation mRotateAnim;
    /**
     * Constructor.
     */
    public LoginAnim() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.login_anim);
	mLogo = (ImageView) findViewById(R.id.logo_anim);
	mRotateAnim = AnimationUtils.loadAnimation(this, R.anim.rotate_and_scale);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onStart() {
	super.onStart();
        mLogo.startAnimation(mRotateAnim);
    }

}
