/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import javax.net.SocketFactory;
import org.jivesoftware.smack.proxy.DirectSocketFactory;
import org.jivesoftware.smack.proxy.HTTPProxySocketFactory;
import org.jivesoftware.smack.proxy.Socks4ProxySocketFactory;
import org.jivesoftware.smack.proxy.Socks5ProxySocketFactory;

public class ProxyInfo {
    private String proxyAddress;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private ProxyType proxyType;

    public ProxyInfo(ProxyType proxyType, String string, int n, String string2, String string3) {
        this.proxyType = proxyType;
        this.proxyAddress = string;
        this.proxyPort = n;
        this.proxyUsername = string2;
        this.proxyPassword = string3;
    }

    public static ProxyInfo forHttpProxy(String string, int n, String string2, String string3) {
        return new ProxyInfo(ProxyType.HTTP, string, n, string2, string3);
    }

    public static ProxyInfo forSocks4Proxy(String string, int n, String string2, String string3) {
        return new ProxyInfo(ProxyType.SOCKS4, string, n, string2, string3);
    }

    public static ProxyInfo forSocks5Proxy(String string, int n, String string2, String string3) {
        return new ProxyInfo(ProxyType.SOCKS5, string, n, string2, string3);
    }

    public static ProxyInfo forNoProxy() {
        return new ProxyInfo(ProxyType.NONE, null, 0, null, null);
    }

    public static ProxyInfo forDefaultProxy() {
        return new ProxyInfo(ProxyType.NONE, null, 0, null, null);
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public SocketFactory getSocketFactory() {
        if (this.proxyType == ProxyType.NONE) {
            return new DirectSocketFactory();
        }
        if (this.proxyType == ProxyType.HTTP) {
            return new HTTPProxySocketFactory(this);
        }
        if (this.proxyType == ProxyType.SOCKS4) {
            return new Socks4ProxySocketFactory(this);
        }
        if (this.proxyType == ProxyType.SOCKS5) {
            return new Socks5ProxySocketFactory(this);
        }
        return null;
    }

    public static enum ProxyType {
        NONE,
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

