/**
 *
 */
package com.beem.project.beem.jingle;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/**
 * @author darisk
 * 
 */
public class RTPMediaSession extends JingleMediaSession {

	private static final SmackLogger LOGGER = SmackLogger
	.getLogger(RTPMediaSession.class);
	private RTPTransmitter transmitter;
	private RTPReceiver receiver;

	/**
	 * @param payloadType
	 * @param remote
	 * @param local
	 * @param mediaLocator
	 * @param jingleSession
	 */
	public RTPMediaSession(PayloadType payloadType,
			TransportCandidate remote, TransportCandidate local,
			String mediaLocator, JingleSession jingleSession) {

		super(payloadType, remote, local, mediaLocator, jingleSession);
		initialize();
		LOGGER.info("Demarrage d'une session avec local: " + local
				+ " #remote: " + remote);

		transmitter = new RTPTransmitter(remote.getIp(), getRemote().getPort());
		receiver = new RTPReceiver(getLocal().getPort());
	}

	@Override
	public void initialize() {
		// TODO Auto-generated method stub

	}

	@Override
	public void setTrasmit(boolean active) {	
	}

	@Override
	public void startReceive() {

	}

	@Override
	public void startTrasmit() {

	}

	@Override
	public void stopReceive() {
		if (receiver != null) {
			receiver.stop();
		}
	}

	@Override
	public void stopTrasmit() {
		if (transmitter != null) {
			transmitter.stop();
		}
	}
}
