/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.PEPListener;
import org.jivesoftware.smackx.packet.PEPEvent;
import org.jivesoftware.smackx.packet.PEPItem;
import org.jivesoftware.smackx.packet.PEPPubSub;

public class PEPManager {
    private List<PEPListener> pepListeners = new ArrayList<PEPListener>();
    private Connection connection;
    private PacketFilter packetFilter = new PacketExtensionFilter("event", "http://jabber.org/protocol/pubsub#event");
    private PacketListener packetListener;

    public PEPManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPEPListener(PEPListener pEPListener) {
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            if (!this.pepListeners.contains(pEPListener)) {
                this.pepListeners.add(pEPListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePEPListener(PEPListener pEPListener) {
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            this.pepListeners.remove(pEPListener);
        }
    }

    public void publish(PEPItem pEPItem) {
        PEPPubSub pEPPubSub = new PEPPubSub(pEPItem);
        pEPPubSub.setType(IQ.Type.SET);
        this.connection.sendPacket(pEPPubSub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePEPListeners(String string, PEPEvent pEPEvent) {
        PEPListener[] pEPListenerArray = null;
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            pEPListenerArray = new PEPListener[this.pepListeners.size()];
            this.pepListeners.toArray(pEPListenerArray);
        }
        for (int i = 0; i < pEPListenerArray.length; ++i) {
            pEPListenerArray[i].eventReceived(string, pEPEvent);
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                PEPEvent pEPEvent = (PEPEvent)message.getExtension("event", "http://jabber.org/protocol/pubsub#event");
                PEPManager.this.firePEPListeners(message.getFrom(), pEPEvent);
            }
        };
        this.connection.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void destroy() {
        if (this.connection != null) {
            this.connection.removePacketListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

