/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class RoomInfo {
    private String room;
    private String description = "";
    private String subject = "";
    private int occupantsCount = -1;
    private boolean membersOnly;
    private boolean moderated;
    private boolean nonanonymous;
    private boolean passwordProtected;
    private boolean persistent;

    RoomInfo(DiscoverInfo discoverInfo) {
        this.room = discoverInfo.getFrom();
        this.membersOnly = discoverInfo.containsFeature("muc_membersonly");
        this.moderated = discoverInfo.containsFeature("muc_moderated");
        this.nonanonymous = discoverInfo.containsFeature("muc_nonanonymous");
        this.passwordProtected = discoverInfo.containsFeature("muc_passwordprotected");
        this.persistent = discoverInfo.containsFeature("muc_persistent");
        Form form = Form.getFormFrom(discoverInfo);
        if (form != null) {
            FormField formField = form.getField("muc#roominfo_description");
            this.description = formField == null || !formField.getValues().hasNext() ? "" : formField.getValues().next();
            FormField formField2 = form.getField("muc#roominfo_subject");
            this.subject = formField2 == null || !formField2.getValues().hasNext() ? "" : formField2.getValues().next();
            FormField formField3 = form.getField("muc#roominfo_occupants");
            this.occupantsCount = formField3 == null ? -1 : Integer.parseInt(formField3.getValues().next());
        }
    }

    public String getRoom() {
        return this.room;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getOccupantsCount() {
        return this.occupantsCount;
    }

    public boolean isMembersOnly() {
        return this.membersOnly;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public boolean isNonanonymous() {
        return this.nonanonymous;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

