/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Iterator;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.xmlpull.v1.XmlPullParser;

public class RTPBridge
extends IQ {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(RTPBridge.class);
    private String sid;
    private String pass;
    private String ip;
    private String name;
    private int portA = -1;
    private int portB = -1;
    private String hostA;
    private String hostB;
    private BridgeAction bridgeAction = BridgeAction.create;
    public static final String NAME = "rtpbridge";
    public static final String ELEMENT_NAME = "rtpbridge";
    public static final String NAMESPACE = "http://www.jivesoftware.com/protocol/rtpbridge";

    public RTPBridge(String string) {
        this.sid = string;
    }

    public RTPBridge(BridgeAction bridgeAction) {
        this.bridgeAction = bridgeAction;
    }

    public RTPBridge(String string, BridgeAction bridgeAction) {
        this.sid = string;
        this.bridgeAction = bridgeAction;
    }

    public RTPBridge() {
    }

    public String getAttributes() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getSid() != null) {
            stringBuilder.append(" sid='").append(this.getSid()).append("'");
        }
        if (this.getPass() != null) {
            stringBuilder.append(" pass='").append(this.getPass()).append("'");
        }
        if (this.getPortA() != -1) {
            stringBuilder.append(" porta='").append(this.getPortA()).append("'");
        }
        if (this.getPortB() != -1) {
            stringBuilder.append(" portb='").append(this.getPortB()).append("'");
        }
        if (this.getHostA() != null) {
            stringBuilder.append(" hosta='").append(this.getHostA()).append("'");
        }
        if (this.getHostB() != null) {
            stringBuilder.append(" hostb='").append(this.getHostB()).append("'");
        }
        return stringBuilder.toString();
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String string) {
        this.sid = string;
    }

    public String getHostA() {
        return this.hostA;
    }

    public void setHostA(String string) {
        this.hostA = string;
    }

    public String getHostB() {
        return this.hostB;
    }

    public void setHostB(String string) {
        this.hostB = string;
    }

    public int getPortA() {
        return this.portA;
    }

    public void setPortA(int n) {
        this.portA = n;
    }

    public int getPortB() {
        return this.portB;
    }

    public void setPortB(int n) {
        this.portB = n;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<rtpbridge xmlns='http://www.jivesoftware.com/protocol/rtpbridge' sid='").append(this.sid).append("'>");
        if (this.bridgeAction.equals((Object)BridgeAction.create)) {
            stringBuilder.append("<candidate/>");
        } else if (this.bridgeAction.equals((Object)BridgeAction.change)) {
            stringBuilder.append("<relay ").append(this.getAttributes()).append(" />");
        } else {
            stringBuilder.append("<publicip ").append(this.getAttributes()).append(" />");
        }
        stringBuilder.append("</rtpbridge>");
        return stringBuilder.toString();
    }

    public static RTPBridge getRTPBridge(XMPPConnection xMPPConnection, String string) {
        if (!xMPPConnection.isConnected()) {
            return null;
        }
        RTPBridge rTPBridge = new RTPBridge(string);
        rTPBridge.setTo("rtpbridge." + xMPPConnection.getServiceName());
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(rTPBridge.getPacketID()));
        xMPPConnection.sendPacket(rTPBridge);
        RTPBridge rTPBridge2 = (RTPBridge)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        return rTPBridge2;
    }

    public static boolean serviceAvailable(XMPPConnection xMPPConnection) {
        if (!xMPPConnection.isConnected()) {
            return false;
        }
        LOGGER.debug("Service listing");
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        try {
            DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(xMPPConnection.getServiceName());
            Iterator<DiscoverInfo.Identity> iterator = discoverInfo.getIdentities();
            while (iterator.hasNext()) {
                DiscoverInfo.Identity identity = iterator.next();
                if (identity.getName() == null || !identity.getName().startsWith("rtpbridge")) continue;
                return true;
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return false;
    }

    public static RTPBridge relaySession(XMPPConnection xMPPConnection, String string, String string2, TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
        if (!xMPPConnection.isConnected()) {
            return null;
        }
        RTPBridge rTPBridge = new RTPBridge(string, BridgeAction.change);
        rTPBridge.setTo("rtpbridge." + xMPPConnection.getServiceName());
        rTPBridge.setType(IQ.Type.SET);
        rTPBridge.setPass(string2);
        rTPBridge.setPortA(transportCandidate2.getPort());
        rTPBridge.setPortB(transportCandidate.getPort());
        rTPBridge.setHostA(transportCandidate2.getIp());
        rTPBridge.setHostB(transportCandidate.getIp());
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(rTPBridge.getPacketID()));
        xMPPConnection.sendPacket(rTPBridge);
        RTPBridge rTPBridge2 = (RTPBridge)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        return rTPBridge2;
    }

    public static String getPublicIP(XMPPConnection xMPPConnection) {
        if (!xMPPConnection.isConnected()) {
            return null;
        }
        RTPBridge rTPBridge = new RTPBridge(BridgeAction.publicip);
        rTPBridge.setTo("rtpbridge." + xMPPConnection.getServiceName());
        rTPBridge.setType(IQ.Type.SET);
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(rTPBridge.getPacketID()));
        xMPPConnection.sendPacket(rTPBridge);
        RTPBridge rTPBridge2 = (RTPBridge)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (rTPBridge2 == null) {
            return null;
        }
        if (rTPBridge2.getIp() == null || rTPBridge2.getIp().equals("")) {
            return null;
        }
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().indexOf(rTPBridge2.getIp()) < 0) continue;
                return null;
            }
        }
        return rTPBridge2.getIp();
    }

    static {
        ProviderManager.getInstance().addIQProvider("rtpbridge", NAMESPACE, new Provider());
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            int n;
            boolean bl = false;
            if (!xmlPullParser.getNamespace().equals(RTPBridge.NAMESPACE)) {
                throw new Exception("Not a RTP Bridge packet");
            }
            RTPBridge rTPBridge = new RTPBridge();
            for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
                if (!xmlPullParser.getAttributeName(n).equals("sid")) continue;
                rTPBridge.setSid(xmlPullParser.getAttributeValue(n));
            }
            while (!bl) {
                int n2 = xmlPullParser.next();
                String string = xmlPullParser.getName();
                String string2 = xmlPullParser.getNamespace();
                if (n2 == 2) {
                    if (string.equals("candidate")) {
                        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
                            if (xmlPullParser.getAttributeName(n).equals("ip")) {
                                rTPBridge.setIp(xmlPullParser.getAttributeValue(n));
                                continue;
                            }
                            if (xmlPullParser.getAttributeName(n).equals("pass")) {
                                rTPBridge.setPass(xmlPullParser.getAttributeValue(n));
                                continue;
                            }
                            if (xmlPullParser.getAttributeName(n).equals("name")) {
                                rTPBridge.setName(xmlPullParser.getAttributeValue(n));
                                continue;
                            }
                            if (xmlPullParser.getAttributeName(n).equals("porta")) {
                                rTPBridge.setPortA(Integer.parseInt(xmlPullParser.getAttributeValue(n)));
                                continue;
                            }
                            if (!xmlPullParser.getAttributeName(n).equals("portb")) continue;
                            rTPBridge.setPortB(Integer.parseInt(xmlPullParser.getAttributeValue(n)));
                        }
                        continue;
                    }
                    if (!string.equals("publicip")) continue;
                    n = xmlPullParser.getAttributeCount();
                    for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                        if (!xmlPullParser.getAttributeName(i).equals("ip")) continue;
                        rTPBridge.setIp(xmlPullParser.getAttributeValue(i));
                    }
                    continue;
                }
                if (n2 != 3 || !xmlPullParser.getName().equals("rtpbridge")) continue;
                bl = true;
            }
            return rTPBridge;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BridgeAction {
        create,
        change,
        publicip;

    }
}

