/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.listeners.CreatedJingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.ICEResolver;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.RTPBridge;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;

public class ICETransportManager
extends JingleTransportManager
implements JingleSessionListener,
CreatedJingleSessionListener {
    ICEResolver iceResolver = null;

    public ICETransportManager(XMPPConnection xmppConnection, String server, int port) {
        this.iceResolver = new ICEResolver(xmppConnection, server, port);
        try {
            this.iceResolver.initializeAndWait();
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    protected TransportResolver createResolver(JingleSession session) {
        try {
            this.iceResolver.resolve(session);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
        return this.iceResolver;
    }

    public void sessionEstablished(PayloadType pt, TransportCandidate rc, TransportCandidate lc, JingleSession jingleSession) {
        if (lc instanceof ICECandidate && ((ICECandidate)lc).getType().equals("relay")) {
            RTPBridge rtpBridge = RTPBridge.relaySession(lc.getConnection(), lc.getSessionId(), lc.getPassword(), rc, lc);
        }
    }

    public void sessionDeclined(String reason, JingleSession jingleSession) {
    }

    public void sessionRedirected(String redirection, JingleSession jingleSession) {
    }

    public void sessionClosed(String reason, JingleSession jingleSession) {
    }

    public void sessionClosedOnError(XMPPException e, JingleSession jingleSession) {
    }

    public void sessionMediaReceived(JingleSession jingleSession, String participant) {
    }

    public void sessionCreated(JingleSession jingleSession) {
        jingleSession.addListener(this);
    }
}

