package com.beem.project.beem.smack.avatar;

import java.util.List;
import java.util.Arrays;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Item;

public class XmppAvatarRetriever implements AvatarRetriever {

    private PubSubManager mPubsub;
    private String mFrom;
    private String mId;
    private static String AVATARDATANODE = "urn:xmpp:avatar:data";

    public XmppAvatarRetriever(XMPPConnection con, String from, String id) {
	mPubsub = new PubSubManager(con, from);
	mFrom = from;
	mId = id;
    }

    @Override
    public byte[] getAvatar() {
	try {
	    Node node = mPubsub.getNode(AVATARDATANODE);
	    if (node instanceof LeafNode) {
		LeafNode lnode = (LeafNode) node;
		List<Item> items = lnode.getItems(Arrays.asList(mId));
		// TODO la suite
	    }
	
	} catch (XMPPException e) {
	    return null;
	}
		return null;
    }

}
