/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.settings.ChatSetting;
import org.xmlpull.v1.XmlPullParser;

public class ChatSettings
extends IQ {
    public static final int IMAGE_SETTINGS = 0;
    public static final int TEXT_SETTINGS = 1;
    public static final int BOT_SETTINGS = 2;
    private List settings;
    private String key;
    private int type = -1;
    public static final String ELEMENT_NAME = "chat-settings";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public ChatSettings() {
        this.settings = new ArrayList();
    }

    public ChatSettings(String string) {
        this.setKey(string);
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void addSetting(ChatSetting chatSetting) {
        this.settings.add(chatSetting);
    }

    public Collection getSettings() {
        return this.settings;
    }

    public ChatSetting getChatSetting(String string) {
        Collection collection = this.getSettings();
        if (collection != null) {
            for (ChatSetting chatSetting : collection) {
                if (!chatSetting.getKey().equals(string)) continue;
                return chatSetting;
            }
        }
        return null;
    }

    public ChatSetting getFirstEntry() {
        if (this.settings.size() > 0) {
            return (ChatSetting)this.settings.get(0);
        }
        return null;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=");
        stringBuilder.append('\"');
        stringBuilder.append(NAMESPACE);
        stringBuilder.append('\"');
        if (this.key != null) {
            stringBuilder.append(" key=\"" + this.key + "\"");
        }
        if (this.type != -1) {
            stringBuilder.append(" type=\"" + this.type + "\"");
        }
        stringBuilder.append("></").append(ELEMENT_NAME).append("> ");
        return stringBuilder.toString();
    }

    public static class InternalProvider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            ChatSettings chatSettings = new ChatSettings();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "chat-setting".equals(xmlPullParser.getName())) {
                    chatSettings.addSetting(this.parseChatSetting(xmlPullParser));
                    continue;
                }
                if (n != 3 || !ChatSettings.ELEMENT_NAME.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return chatSettings;
        }

        private ChatSetting parseChatSetting(XmlPullParser xmlPullParser) throws Exception {
            boolean bl = false;
            String string = null;
            String string2 = null;
            int n = 0;
            while (!bl) {
                int n2 = xmlPullParser.next();
                if (n2 == 2 && "key".equals(xmlPullParser.getName())) {
                    string = xmlPullParser.nextText();
                    continue;
                }
                if (n2 == 2 && "value".equals(xmlPullParser.getName())) {
                    string2 = xmlPullParser.nextText();
                    continue;
                }
                if (n2 == 2 && "type".equals(xmlPullParser.getName())) {
                    n = Integer.parseInt(xmlPullParser.nextText());
                    continue;
                }
                if (n2 != 3 || !"chat-setting".equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return new ChatSetting(string, string2, n);
        }
    }
}

