/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import org.jlibrtp.jlibrtp.RTPSession;
import org.jlibrtp.jlibrtp.RtcpPkt;
import org.jlibrtp.jlibrtp.StaticProcs;

public class RtcpPktRTPFB
extends RtcpPkt {
    protected boolean notRelevant = false;
    protected long ssrcMediaSource = -1L;
    protected int[] PID;
    protected int[] BLP;

    protected RtcpPktRTPFB(long ssrcPacketSender, long ssrcMediaSource, int FMT, int[] PID, int[] BLP) {
        this.packetType = 205;
        this.itemCount = FMT;
        this.PID = PID;
        this.BLP = BLP;
    }

    protected RtcpPktRTPFB(byte[] aRawPkt, int start, RTPSession rtpSession) {
        this.rawPkt = aRawPkt;
        if (!super.parseHeaders(start) || this.packetType != 205 || this.length < 2) {
            this.problem = -205;
        } else {
            this.ssrcMediaSource = StaticProcs.bytesToUIntLong(aRawPkt, 8 + start);
            if (this.ssrcMediaSource == rtpSession.ssrc) {
                this.ssrc = StaticProcs.bytesToUIntLong(aRawPkt, 4 + start);
                int loopStop = this.length - 2;
                this.PID = new int[loopStop];
                this.BLP = new int[loopStop];
                int curStart = 12;
                int i = 0;
                while (i < loopStop) {
                    this.PID[i] = StaticProcs.bytesToUIntInt(aRawPkt, curStart);
                    this.BLP[i] = StaticProcs.bytesToUIntInt(aRawPkt, curStart + 2);
                    curStart += 4;
                    ++i;
                }
                rtpSession.rtcpAVPFIntf.RTPFBPktReceived(this.ssrc, this.itemCount, this.PID, this.BLP);
            }
        }
    }

    @Override
    protected void encode() {
        this.rawPkt = new byte[12 + this.PID.length * 4];
        byte[] someBytes = StaticProcs.uIntLongToByteWord(this.ssrc);
        System.arraycopy(someBytes, 0, this.rawPkt, 4, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.ssrcMediaSource);
        System.arraycopy(someBytes, 0, this.rawPkt, 8, 4);
        int curStart = 12;
        int i = 0;
        while (i < this.PID.length) {
            someBytes = StaticProcs.uIntIntToByteWord(this.PID[i]);
            this.rawPkt[curStart++] = someBytes[0];
            this.rawPkt[curStart++] = someBytes[1];
            someBytes = StaticProcs.uIntIntToByteWord(this.BLP[i]);
            this.rawPkt[curStart++] = someBytes[0];
            this.rawPkt[curStart++] = someBytes[1];
            ++i;
        }
        this.writeHeaders();
    }

    protected int getFMT() {
        return this.itemCount;
    }

    protected void debugPrint() {
        System.out.println("->RtcpPktRTPFB.debugPrint() ");
        System.out.println("  ssrcPacketSender: " + this.ssrc + "  ssrcMediaSource: " + this.ssrcMediaSource);
        if (this.PID != null && this.PID.length < 1) {
            System.out.println("  No Feedback Control Information (FCI) fields");
        }
        int i = 0;
        while (i < this.PID.length) {
            System.out.println("  FCI -> PID: " + this.PID[i] + "  BLP: " + this.BLP[i]);
            ++i;
        }
        System.out.println("<-RtcpPktRTPFB.debugPrint() ");
    }
}

