/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class OutgoingFileTransfer
extends FileTransfer {
    private static int RESPONSE_TIMEOUT = 60000;
    private NegotiationProgress callback;
    private OutputStream outputStream;
    private String initiator;
    private Thread transferThread;

    public static int getResponseTimeout() {
        return RESPONSE_TIMEOUT;
    }

    public static void setResponseTimeout(int n) {
        RESPONSE_TIMEOUT = n;
    }

    protected OutgoingFileTransfer(String string, String string2, String string3, FileTransferNegotiator fileTransferNegotiator) {
        super(string2, string3, fileTransferNegotiator);
        this.initiator = string;
    }

    protected void setOutputStream(OutputStream outputStream) {
        if (this.outputStream == null) {
            this.outputStream = outputStream;
        }
    }

    protected OutputStream getOutputStream() {
        if (this.getStatus().equals((Object)FileTransfer.Status.negotiated)) {
            return this.outputStream;
        }
        return null;
    }

    public synchronized OutputStream sendFile(String string, long l, String string2) throws XMPPException {
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted on this file transfer");
        }
        try {
            this.setFileInfo(string, l);
            this.outputStream = this.negotiateStream(string, l, string2);
        }
        catch (XMPPException xMPPException) {
            this.handleXMPPException(xMPPException);
            throw xMPPException;
        }
        return this.outputStream;
    }

    public synchronized void sendFile(final String string, final long l, final String string2, final NegotiationProgress negotiationProgress) {
        if (negotiationProgress == null) {
            throw new IllegalArgumentException("Callback progress cannot be null.");
        }
        this.checkTransferThread();
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted for this file transfer");
        }
        this.setFileInfo(string, l);
        this.callback = negotiationProgress;
        this.transferThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(string, l, string2);
                    negotiationProgress.outputStreamEstablished(OutgoingFileTransfer.this.outputStream);
                }
                catch (XMPPException xMPPException) {
                    OutgoingFileTransfer.this.handleXMPPException(xMPPException);
                }
            }
        }, "File Transfer Negotiation " + this.streamID);
        this.transferThread.start();
    }

    private void checkTransferThread() {
        if (this.transferThread != null && this.transferThread.isAlive() || this.isDone()) {
            throw new IllegalStateException("File transfer in progress or has already completed.");
        }
    }

    public synchronized void sendFile(final File file, final String string) throws XMPPException {
        this.checkTransferThread();
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Could not read file");
        }
        this.setFileInfo(file.getAbsolutePath(), file.getName(), file.length());
        this.transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(file.getName(), file.length(), string);
                }
                catch (XMPPException xMPPException) {
                    OutgoingFileTransfer.this.handleXMPPException(xMPPException);
                    return;
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    OutgoingFileTransfer.this.writeToStream(fileInputStream, OutgoingFileTransfer.this.outputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    OutgoingFileTransfer.this.setException(fileNotFoundException);
                }
                catch (XMPPException xMPPException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(xMPPException);
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            ((InputStream)fileInputStream).close();
                        }
                        OutgoingFileTransfer.this.outputStream.flush();
                        OutgoingFileTransfer.this.outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    public synchronized void sendStream(final InputStream inputStream, final String string, final long l, final String string2) {
        this.checkTransferThread();
        this.setFileInfo(string, l);
        this.transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutgoingFileTransfer.this.setFileInfo(string, l);
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(string, l, string2);
                }
                catch (XMPPException xMPPException) {
                    OutgoingFileTransfer.this.handleXMPPException(xMPPException);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(illegalStateException);
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                try {
                    OutgoingFileTransfer.this.writeToStream(inputStream, OutgoingFileTransfer.this.outputStream);
                }
                catch (XMPPException xMPPException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(xMPPException);
                }
                catch (IllegalStateException illegalStateException) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException(illegalStateException);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        OutgoingFileTransfer.this.outputStream.flush();
                        OutgoingFileTransfer.this.outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    private void handleXMPPException(XMPPException xMPPException) {
        XMPPError xMPPError = xMPPException.getXMPPError();
        if (xMPPError != null) {
            int n = xMPPError.getCode();
            if (n == 403) {
                this.setStatus(FileTransfer.Status.refused);
                return;
            }
            if (n == 400) {
                this.setStatus(FileTransfer.Status.error);
                this.setError(FileTransfer.Error.not_acceptable);
            } else {
                this.setStatus(FileTransfer.Status.error);
            }
        }
        this.setException(xMPPException);
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    private OutputStream negotiateStream(String string, long l, String string2) throws XMPPException {
        if (!this.updateStatus(FileTransfer.Status.initial, FileTransfer.Status.negotiating_transfer)) {
            throw new XMPPException("Illegal state change");
        }
        StreamNegotiator streamNegotiator = this.negotiator.negotiateOutgoingTransfer(this.getPeer(), this.streamID, string, l, string2, RESPONSE_TIMEOUT);
        if (streamNegotiator == null) {
            this.setStatus(FileTransfer.Status.error);
            this.setError(FileTransfer.Error.no_response);
            return null;
        }
        if (!this.updateStatus(FileTransfer.Status.negotiating_transfer, FileTransfer.Status.negotiating_stream)) {
            throw new XMPPException("Illegal state change");
        }
        this.outputStream = streamNegotiator.createOutgoingStream(this.streamID, this.initiator, this.getPeer());
        if (!this.updateStatus(FileTransfer.Status.negotiating_stream, FileTransfer.Status.negotiated)) {
            throw new XMPPException("Illegal state change");
        }
        return this.outputStream;
    }

    @Override
    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }

    @Override
    protected boolean updateStatus(FileTransfer.Status status, FileTransfer.Status status2) {
        boolean bl = super.updateStatus(status, status2);
        if (this.callback != null && bl) {
            this.callback.statusUpdated(status, status2);
        }
        return bl;
    }

    @Override
    protected void setStatus(FileTransfer.Status status) {
        FileTransfer.Status status2 = this.getStatus();
        super.setStatus(status);
        if (this.callback != null) {
            this.callback.statusUpdated(status2, status);
        }
    }

    @Override
    protected void setException(Exception exception) {
        super.setException(exception);
        if (this.callback != null) {
            this.callback.errorEstablishingStream(exception);
        }
    }

    public static interface NegotiationProgress {
        public void statusUpdated(FileTransfer.Status var1, FileTransfer.Status var2);

        public void outputStreamEstablished(OutputStream var1);

        public void errorEstablishingStream(Exception var1);
    }
}

