package com.beem.project.beem.service;

import org.jivesoftware.smack.packet.Presence;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.RemoteException;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.service.aidl.IChatManager;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppConnection;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.ui.ChangeStatus;
import com.beem.project.beem.utils.PresenceType;

/**
 * This class is a facade for the Beem Service.
 * 
 * @author darisk
 */
public class XmppFacade extends IXmppFacade.Stub {

    private XmppConnectionAdapter mConnexion;
    private BeemService           mBeemService;

    /**
     * Constructor for XMPPFacade.
     * 
     * @param connection
     *            the connection use by the facade
     * @param service
     *            the service which holds the facade
     */
    public XmppFacade(final XmppConnectionAdapter connection, final BeemService service) {
	this.mConnexion = connection;
	this.mBeemService = service;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void changeStatus(int status, String msg) {
	Presence pres = new Presence(Presence.Type.available);
	if (msg != null)
	    pres.setStatus(msg);
	Presence.Mode mode = com.beem.project.beem.utils.Status.getPresenceModeFromStatus(status);
	if (mode != null)
	    pres.setMode(mode);
	mConnexion.getAdaptee().sendPacket(pres);

	Notification mStatusNotification;
	String text = (msg == null ? "" : msg);
	mStatusNotification = new Notification(com.beem.project.beem.R.drawable.notify_signal, text, System
	        .currentTimeMillis());
	mStatusNotification.defaults = Notification.DEFAULT_ALL;
	mStatusNotification.flags = Notification.FLAG_NO_CLEAR;

	mStatusNotification.setLatestEventInfo(mBeemService, "Beem Status", text, PendingIntent.getActivity(
	        mBeemService, 0, new Intent(mBeemService, ChangeStatus.class), 0));
	mBeemService.sendNotification(BeemService.NOTIFICATION_STATUS_ID, mStatusNotification);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectAsync() throws RemoteException {
	mConnexion.connectAsync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectSync() throws RemoteException {
	mConnexion.connectSync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IXmppConnection createConnection() throws RemoteException {
	return mConnexion;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void disconnect() throws RemoteException {
	mConnexion.disconnect();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IChatManager getChatManager() throws RemoteException {
	return mConnexion.getChatManager();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IRoster getRoster() throws RemoteException {
	return mConnexion.getRoster();
    }

    @Override
    public void sendPresencePacket(PresenceAdapter presence) throws RemoteException {
	Presence presence2 = new Presence(PresenceType.getPresenceTypeFrom(presence.getType()));
	presence2.setTo(presence.getTo());
	mConnexion.getAdaptee().sendPacket(presence2);
    }

    @Override
    public void blockUser(String jid) throws RemoteException {
	mConnexion.getPrivacyList().addBlockedUser(jid);
    }
}
