/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.CreatedJingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionRequestListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.provider.JingleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleManager
implements JingleSessionListener {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleManager.class);
    final List<JingleSession> jingleSessions = new ArrayList<JingleSession>();
    private List<JingleSessionRequestListener> jingleSessionRequestListeners;
    private List<CreatedJingleSessionListener> creationListeners = new ArrayList<CreatedJingleSessionListener>();
    private XMPPConnection connection;
    private List<JingleMediaManager> jingleMediaManagers;

    public JingleManager(XMPPConnection xMPPConnection, List<JingleMediaManager> list) {
        this.connection = xMPPConnection;
        this.jingleMediaManagers = list;
        xMPPConnection.getRoster().addRosterListener(new RosterListener(){

            public void entriesAdded(Collection collection) {
            }

            public void entriesUpdated(Collection collection) {
            }

            public void entriesDeleted(Collection collection) {
            }

            public void presenceChanged(Presence presence) {
                if (!presence.isAvailable()) {
                    String string = presence.getFrom();
                    JingleSession jingleSession = null;
                    for (JingleSession jingleSession2 : JingleManager.this.jingleSessions) {
                        if (!jingleSession2.getInitiator().equals(string) && !jingleSession2.getResponder().equals(string)) continue;
                        jingleSession = jingleSession2;
                    }
                    if (jingleSession != null) {
                        try {
                            jingleSession.terminate();
                        }
                        catch (XMPPException xMPPException) {
                            xMPPException.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void setJingleServiceEnabled() {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("jingle", "urn:xmpp:tmp:jingle", new JingleProvider());
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                JingleManager.setServiceEnabled(xMPPConnection, true);
            }
        });
    }

    public static synchronized void setServiceEnabled(XMPPConnection xMPPConnection, boolean bl) {
        if (JingleManager.isServiceEnabled(xMPPConnection) == bl) {
            return;
        }
        if (bl) {
            ServiceDiscoveryManager.getInstanceFor(xMPPConnection).addFeature("urn:xmpp:tmp:jingle");
        } else {
            ServiceDiscoveryManager.getInstanceFor(xMPPConnection).removeFeature("urn:xmpp:tmp:jingle");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection) {
        return ServiceDiscoveryManager.getInstanceFor(xMPPConnection).includesFeature("urn:xmpp:tmp:jingle");
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection, String string) {
        try {
            DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(xMPPConnection).discoverInfo(string);
            return discoverInfo.containsFeature("urn:xmpp:tmp:jingle");
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return false;
        }
    }

    public List<JingleMediaManager> getMediaManagers() {
        return this.jingleMediaManagers;
    }

    public void setMediaManagers(List<JingleMediaManager> list) {
        this.jingleMediaManagers = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (jingleSessionRequestListener != null) {
            if (this.jingleSessionRequestListeners == null) {
                this.initJingleSessionRequestListeners();
            }
            List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
            synchronized (list) {
                this.jingleSessionRequestListeners.add(jingleSessionRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (this.jingleSessionRequestListeners == null) {
            return;
        }
        List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
        synchronized (list) {
            this.jingleSessionRequestListeners.remove(jingleSessionRequestListener);
        }
    }

    public void addCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.add(createdJingleSessionListener);
    }

    public void removeCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.remove(createdJingleSessionListener);
    }

    public void triggerSessionCreated(JingleSession jingleSession) {
        this.jingleSessions.add(jingleSession);
        jingleSession.addListener(this);
        for (CreatedJingleSessionListener createdJingleSessionListener : this.creationListeners) {
            try {
                createdJingleSessionListener.sessionCreated(jingleSession);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void sessionEstablished(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2, JingleSession jingleSession) {
    }

    @Override
    public void sessionDeclined(String string, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
        jingleSession.close();
        LOGGER.error("Declined:" + string);
    }

    @Override
    public void sessionRedirected(String string, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosed(String string, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosedOnError(XMPPException xMPPException, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionMediaReceived(JingleSession jingleSession, String string) {
    }

    private void initJingleSessionRequestListeners() {
        PacketFilter packetFilter = new PacketFilter(){

            public boolean accept(Packet packet) {
                Jingle jingle;
                IQ iQ;
                return packet instanceof IQ && (iQ = (IQ)packet).getType().equals(IQ.Type.SET) && iQ instanceof Jingle && (jingle = (Jingle)packet).getAction().equals((Object)JingleActionEnum.SESSION_INITIATE);
            }
        };
        this.jingleSessionRequestListeners = new ArrayList<JingleSessionRequestListener>();
        this.connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                JingleManager.this.triggerSessionRequested((Jingle)packet);
            }
        }, packetFilter);
    }

    public void disconnectAllSessions() {
        List<JingleSession> list = this.jingleSessions.subList(0, this.jingleSessions.size());
        for (JingleSession jingleSession : list) {
            try {
                jingleSession.terminate();
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
        list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerSessionRequested(Jingle jingle) {
        JingleSessionRequestListener[] jingleSessionRequestListenerArray = null;
        Object object = this.jingleSessionRequestListeners;
        synchronized (object) {
            jingleSessionRequestListenerArray = new JingleSessionRequestListener[this.jingleSessionRequestListeners.size()];
            this.jingleSessionRequestListeners.toArray(jingleSessionRequestListenerArray);
        }
        object = new JingleSessionRequest(this, jingle);
        for (int i = 0; i < jingleSessionRequestListenerArray.length; ++i) {
            jingleSessionRequestListenerArray[i].sessionRequested((JingleSessionRequest)object);
        }
    }

    public JingleSession createOutgoingJingleSession(String string) throws XMPPException {
        if (string == null || StringUtils.parseName(string).length() <= 0 || StringUtils.parseServer(string).length() <= 0 || StringUtils.parseResource(string).length() <= 0) {
            throw new IllegalArgumentException("The provided user id was not fully qualified");
        }
        JingleSession jingleSession = new JingleSession(this.connection, (JingleSessionRequest)null, this.connection.getUser(), string, this.jingleMediaManagers);
        this.triggerSessionCreated(jingleSession);
        return jingleSession;
    }

    public JingleSession createIncomingJingleSession(JingleSessionRequest jingleSessionRequest) throws XMPPException {
        if (jingleSessionRequest == null) {
            throw new NullPointerException("Received request cannot be null");
        }
        JingleSession jingleSession = new JingleSession(this.connection, jingleSessionRequest, jingleSessionRequest.getFrom(), this.connection.getUser(), this.jingleMediaManagers);
        this.triggerSessionCreated(jingleSession);
        return jingleSession;
    }

    public JingleSession getSession(String string) {
        for (JingleSession jingleSession : this.jingleSessions) {
            if (!jingleSession.getResponder().equals(string)) continue;
            return jingleSession;
        }
        return null;
    }
}

