/**
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Véronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program “Beem”
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.provider;

import android.net.Uri;
import android.provider.BaseColumns;

// TODO: Auto-generated Javadoc
/**
 * Convenience definitions for BEEM's providers.
 */
public final class Beem {

    /**
     * Contacts table.
     */
    public static final class Contacts implements BaseColumns {

	/** The query used to create the table. */
	public static final String QUERY_CREATE = "CREATE TABLE " + Beem.CONTACTS_TABLE_NAME + " (" + BaseColumns._ID
	    + " INTEGER PRIMARY KEY AUTOINCREMENT," + Contacts.UID + " INTEGER, " + Contacts.JID + " INTEGER,"
	    + Contacts.NICKNAME + " TEXT," + Contacts.ALIAS + " TEXT," + Contacts.DATE_CREATED + " INTEGER,"
	    + Contacts.DATE_MODIFIED + " INTEGER" + ");";

	/** The content:// style URL for Contacts table. */
	public static final Uri CONTENT_URI = Uri.parse("content://" + AUTHORITY + "/contacts");

	/** The MIME type of {@link #CONTENT_URI} providing a directory of contacts. */
	public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.beem.project.contact";

	/** The MIME type of a {@link #CONTENT_URI} sub-directory of a single contact. */
	public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.beem.project.contact";

	/** The default sort order for this table. */
	public static final String DEFAULT_SORT_ORDER = "nickname ASC";

	/**
     * The user id having the contact
     * <P>
     * Type: INTEGER
     * </P>
     * .
     */
	public static final String UID = "uid";

	/**
     * The JabberID of the contact
     * <P>
     * Type: INTEGER
     * </P>
     * .
     */
	public static final String JID = "jid";

	/**
     * The nickname of the contact
     * <P>
     * Type: TEXT
     * </P>
     * .
     */
	public static final String NICKNAME = "nickname";

	/**
     * The alias of the contact
     * <P>
     * Type: TEXT
     * </P>
     * .
     */
	public static final String ALIAS = "alias";

	/**
     * The timestamp for when the contact was created
     * <P>
     * Type: INTEGER (long from System.curentTimeMillis())
     * </P>
     * .
     */
	public static final String DATE_CREATED = "created";

	/**
     * The timestamp for when the contact was last modified
     * <P>
     * Type: INTEGER (long from System.curentTimeMillis())
     * </P>
     * .
     */
	public static final String DATE_MODIFIED = "modified";

    }

    /**
     * Users table.
     */
    public static final class Users implements BaseColumns {

	/** The query used to create the table. */
	public static final String QUERY_CREATE = "CREATE TABLE " + Beem.USERS_TABLE_NAME + " (" + BaseColumns._ID
	    + " INTEGER PRIMARY KEY AUTOINCREMENT," + Users.JUSERNAME + " TEXT," + Users.DATE_CREATED + " INTEGER,"
	    + Users.DATE_MODIFIED + " INTEGER" + ");";

	/** The content:// style URL for Contacts table. */
	public static final Uri CONTENT_URI = Uri.parse("content://" + AUTHORITY + "/users");

	/** The MIME type of {@link #CONTENT_URI} providing a directory of users. */
	public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.beem.project.user";

	/** The MIME type of a {@link #CONTENT_URI} sub-directory of a single user. */
	public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.beem.project.user";

	/** The default sort order for this table. */
	public static final String DEFAULT_SORT_ORDER = "_id ASC";

	/**
     * The Jabber username of the user
     * <P>
     * Type: TEXT
     * </P>
     * .
     */
	public static final String JUSERNAME = "username";

	/**
     * The timestamp for when the user was created
     * <P>
     * Type: INTEGER (long from System.curentTimeMillis())
     * </P>
     * .
     */
	public static final String DATE_CREATED = "created";

	/**
     * The timestamp for when the user was last modified
     * <P>
     * Type: INTEGER (long from System.curentTimeMillis())
     * </P>
     * .
     */
	public static final String DATE_MODIFIED = "modified";
    }

    /** AUTHORITY. */
    public static final String AUTHORITY = "com.beem.project.provider";

    /** DB Name. */
    public static final String DB_NAME = "beem.db";

    /** DB Version. */
    public static final int DB_VERSION = 2;

    /** Name of the users table. */
    public static final String USERS_TABLE_NAME = "users";

    /** Name of the contacts table. */
    public static final String CONTACTS_TABLE_NAME = "contacts";

    /**
     * Constructor.
     */
    private Beem() {
    }
}
