/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.Base64;
import security.javax.security.auth.callback.NameCallback;
import security.javax.security.sasl.RealmCallback;
import security.javax.security.sasl.RealmChoiceCallback;
import security.javax.security.sasl.Sasl;
import security.javax.security.sasl.SaslClient;
import security.javax.security.sasl.SaslException;

public abstract class SASLMechanism
implements CallbackHandler {
    private SASLAuthentication saslAuthentication;
    protected SaslClient sc;
    protected String authenticationId;
    protected String password;
    protected String hostname;

    public SASLMechanism(SASLAuthentication saslAuthentication) {
        this.saslAuthentication = saslAuthentication;
    }

    public void authenticate(String username, String host, String password) throws IOException, XMPPException {
        this.authenticationId = username;
        this.password = password;
        this.hostname = host;
        String[] mechanisms = new String[]{this.getName()};
        HashMap props = new HashMap();
        this.sc = Sasl.createSaslClient((String[])mechanisms, (String)username, (String)"xmpp", (String)host, props, (CallbackHandler)this);
        this.authenticate();
    }

    public void authenticate(String username, String host, CallbackHandler cbh) throws IOException, XMPPException {
        String[] mechanisms = new String[]{this.getName()};
        HashMap props = new HashMap();
        this.sc = Sasl.createSaslClient((String[])mechanisms, (String)username, (String)"xmpp", (String)host, props, (CallbackHandler)cbh);
        this.authenticate();
    }

    protected void authenticate() throws IOException, XMPPException {
        String authenticationText = null;
        try {
            if (this.sc.hasInitialResponse()) {
                byte[] response = this.sc.evaluateChallenge(new byte[0]);
                authenticationText = Base64.encodeBytes(response, 8);
            }
        }
        catch (SaslException e) {
            throw new XMPPException("SASL authentication failed", e);
        }
        this.getSASLAuthentication().send(new AuthMechanism(this.getName(), authenticationText));
    }

    public void challengeReceived(String challenge) throws IOException {
        byte[] response = challenge != null ? this.sc.evaluateChallenge(Base64.decode(challenge)) : this.sc.evaluateChallenge(new byte[0]);
        Response responseStanza = response == null ? new Response() : new Response(Base64.encodeBytes(response, 8));
        this.getSASLAuthentication().send(responseStanza);
    }

    protected abstract String getName();

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback ncb = (NameCallback)callbacks[i];
                ncb.setName(this.authenticationId);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)callbacks[i];
                pcb.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)callbacks[i];
                rcb.setText(this.hostname);
                continue;
            }
            if (callbacks[i] instanceof RealmChoiceCallback) continue;
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    public class Response
    extends Packet {
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String authenticationText) {
            this.authenticationText = authenticationText == null || authenticationText.trim().length() == 0 ? null : authenticationText;
        }

        public String toXML() {
            StringBuilder stanza = new StringBuilder();
            stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null) {
                stanza.append(this.authenticationText);
            } else {
                stanza.append("=");
            }
            stanza.append("</response>");
            return stanza.toString();
        }
    }

    public class AuthMechanism
    extends Packet {
        private final String name;
        private final String authenticationText;

        public AuthMechanism(String name, String authenticationText) {
            if (name == null) {
                throw new NullPointerException("SASL mechanism name shouldn't be null.");
            }
            this.name = name;
            this.authenticationText = authenticationText;
        }

        public String toXML() {
            StringBuilder stanza = new StringBuilder();
            stanza.append("<auth mechanism=\"").append(this.name);
            stanza.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null && this.authenticationText.trim().length() > 0) {
                stanza.append(this.authenticationText);
            }
            stanza.append("</auth>");
            return stanza.toString();
        }
    }
}

