/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class Authentication
extends IQ {
    private String username = null;
    private String password = null;
    private String digest = null;
    private String resource = null;

    public Authentication() {
        this.setType(IQ.Type.SET);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String string, String string2) {
        this.digest = StringUtils.hash(string + string2);
    }

    public void setDigest(String string) {
        this.digest = string;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:auth\">");
        if (this.username != null) {
            if (this.username.equals("")) {
                stringBuilder.append("<username/>");
            } else {
                stringBuilder.append("<username>").append(this.username).append("</username>");
            }
        }
        if (this.digest != null) {
            if (this.digest.equals("")) {
                stringBuilder.append("<digest/>");
            } else {
                stringBuilder.append("<digest>").append(this.digest).append("</digest>");
            }
        }
        if (this.password != null && this.digest == null) {
            if (this.password.equals("")) {
                stringBuilder.append("<password/>");
            } else {
                stringBuilder.append("<password>").append(StringUtils.escapeForXML(this.password)).append("</password>");
            }
        }
        if (this.resource != null) {
            if (this.resource.equals("")) {
                stringBuilder.append("<resource/>");
            } else {
                stringBuilder.append("<resource>").append(this.resource).append("</resource>");
            }
        }
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }
}

