/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class SRVRecord
extends Record {
    private static final long serialVersionUID = -3886460132387522052L;
    private int priority;
    private int weight;
    private int port;
    private Name target;

    SRVRecord() {
    }

    @Override
    Record getObject() {
        return new SRVRecord();
    }

    public SRVRecord(Name name, int n, long l, int n2, int n3, int n4, Name name2) {
        super(name, 33, n, l);
        this.priority = SRVRecord.checkU16("priority", n2);
        this.weight = SRVRecord.checkU16("weight", n3);
        this.port = SRVRecord.checkU16("port", n4);
        this.target = SRVRecord.checkName("target", name2);
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.priority = dNSInput.readU16();
        this.weight = dNSInput.readU16();
        this.port = dNSInput.readU16();
        this.target = new Name(dNSInput);
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.priority = tokenizer.getUInt16();
        this.weight = tokenizer.getUInt16();
        this.port = tokenizer.getUInt16();
        this.target = tokenizer.getName(name);
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.priority + " ");
        stringBuffer.append(this.weight + " ");
        stringBuffer.append(this.port + " ");
        stringBuffer.append(this.target);
        return stringBuffer.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.priority);
        dNSOutput.writeU16(this.weight);
        dNSOutput.writeU16(this.port);
        this.target.toWire(dNSOutput, null, bl);
    }

    @Override
    public Name getAdditionalName() {
        return this.target;
    }
}

