/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.StreamInitiation;

public abstract class StreamNegotiator {
    public StreamInitiation createInitiationAccept(StreamInitiation streamInitiation, String[] stringArray) {
        StreamInitiation streamInitiation2 = new StreamInitiation();
        streamInitiation2.setTo(streamInitiation.getFrom());
        streamInitiation2.setFrom(streamInitiation.getTo());
        streamInitiation2.setType(IQ.Type.RESULT);
        streamInitiation2.setPacketID(streamInitiation.getPacketID());
        DataForm dataForm = new DataForm("submit");
        FormField formField = new FormField("stream-method");
        for (String string : stringArray) {
            formField.addValue(string);
        }
        dataForm.addField(formField);
        streamInitiation2.setFeatureNegotiationForm(dataForm);
        return streamInitiation2;
    }

    public IQ createError(String string, String string2, String string3, XMPPError xMPPError) {
        IQ iQ = FileTransferNegotiator.createIQ(string3, string2, string, IQ.Type.ERROR);
        iQ.setError(xMPPError);
        return iQ;
    }

    Packet initiateIncomingStream(XMPPConnection xMPPConnection, StreamInitiation streamInitiation) throws XMPPException {
        StreamInitiation streamInitiation2 = this.createInitiationAccept(streamInitiation, this.getNamespaces());
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(this.getInitiationPacketFilter(streamInitiation.getFrom(), streamInitiation.getSessionID()));
        xMPPConnection.sendPacket(streamInitiation2);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet == null) {
            throw new XMPPException("No response from file transfer initiator");
        }
        return packet;
    }

    public abstract PacketFilter getInitiationPacketFilter(String var1, String var2);

    abstract InputStream negotiateIncomingStream(Packet var1) throws XMPPException;

    public abstract InputStream createIncomingStream(StreamInitiation var1) throws XMPPException;

    public abstract OutputStream createOutgoingStream(String var1, String var2, String var3) throws XMPPException;

    public abstract String[] getNamespaces();

    public abstract void cleanup();
}

