/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.settings;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class SoundSettings
extends IQ {
    private String outgoingSound;
    private String incomingSound;
    public static final String ELEMENT_NAME = "sound-settings";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public void setOutgoingSound(String string) {
        this.outgoingSound = string;
    }

    public void setIncomingSound(String string) {
        this.incomingSound = string;
    }

    public byte[] getIncomingSoundBytes() {
        return StringUtils.decodeBase64(this.incomingSound);
    }

    public byte[] getOutgoingSoundBytes() {
        return StringUtils.decodeBase64(this.outgoingSound);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=");
        stringBuilder.append('\"');
        stringBuilder.append(NAMESPACE);
        stringBuilder.append('\"');
        stringBuilder.append("></").append(ELEMENT_NAME).append("> ");
        return stringBuilder.toString();
    }

    public static class InternalProvider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            SoundSettings soundSettings = new SoundSettings();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "outgoingSound".equals(xmlPullParser.getName())) {
                    soundSettings.setOutgoingSound(xmlPullParser.nextText());
                    continue;
                }
                if (n == 2 && "incomingSound".equals(xmlPullParser.getName())) {
                    soundSettings.setIncomingSound(xmlPullParser.nextText());
                    continue;
                }
                if (n != 3 || !SoundSettings.ELEMENT_NAME.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return soundSettings;
        }
    }
}

