/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import java.io.UnsupportedEncodingException;
import security.javax.security.sasl.SaslClient;
import security.javax.security.sasl.SaslException;

final class ExternalClient
implements SaslClient {
    private byte[] username;
    private boolean completed = false;

    ExternalClient(String authorizationID) throws SaslException {
        if (authorizationID != null) {
            try {
                this.username = authorizationID.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("Cannot convert " + authorizationID + " into UTF-8", e);
            }
        } else {
            this.username = new byte[0];
        }
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public void dispose() throws SaslException {
    }

    @Override
    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("EXTERNAL authentication already completed");
        }
        this.completed = true;
        return this.username;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication Not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            return null;
        }
        throw new IllegalStateException("EXTERNAL authentication not completed");
    }
}

