/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.Section;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Update;
import org.xbill.DNS.WireParseException;

public class Message
implements Cloneable {
    public static final int MAXLENGTH = 65535;
    private Header header;
    private List[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    int tsigstart;
    int tsigState;
    int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static Record[] emptyRecordArray = new Record[0];
    private static RRset[] emptyRRsetArray = new RRset[0];

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int n) {
        this(new Header(n));
    }

    public Message() {
        this(new Header());
    }

    public static Message newQuery(Record record) {
        Message message = new Message();
        message.header.setOpcode(0);
        message.header.setFlag(7);
        message.addRecord(record, 0);
        return message;
    }

    public static Message newUpdate(Name name) {
        return new Update(name);
    }

    Message(DNSInput dNSInput) throws IOException {
        block6: {
            this(new Header(dNSInput));
            boolean bl = this.header.getOpcode() == 5;
            boolean bl2 = this.header.getFlag(6);
            try {
                for (int i = 0; i < 4; ++i) {
                    int n = this.header.getCount(i);
                    if (n > 0) {
                        this.sections[i] = new ArrayList(n);
                    }
                    for (int j = 0; j < n; ++j) {
                        SIGRecord sIGRecord;
                        int n2 = dNSInput.current();
                        Record record = Record.fromWire(dNSInput, i, bl);
                        this.sections[i].add(record);
                        if (i != 3) continue;
                        if (record.getType() == 250) {
                            this.tsigstart = n2;
                        }
                        if (record.getType() != 24 || (sIGRecord = (SIGRecord)record).getTypeCovered() != 0) continue;
                        this.sig0start = n2;
                    }
                }
            }
            catch (WireParseException wireParseException) {
                if (bl2) break block6;
                throw wireParseException;
            }
        }
        this.size = dNSInput.current();
    }

    public Message(byte[] byArray) throws IOException {
        this(new DNSInput(byArray));
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record record, int n) {
        if (this.sections[n] == null) {
            this.sections[n] = new LinkedList();
        }
        this.header.incCount(n);
        this.sections[n].add(record);
    }

    public boolean removeRecord(Record record, int n) {
        if (this.sections[n] != null && this.sections[n].remove(record)) {
            this.header.decCount(n);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int n) {
        this.sections[n] = null;
        this.header.setCount(n, 0);
    }

    public boolean findRecord(Record record, int n) {
        return this.sections[n] != null && this.sections[n].contains(record);
    }

    public boolean findRecord(Record record) {
        for (int i = 1; i <= 3; ++i) {
            if (this.sections[i] == null || !this.sections[i].contains(record)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int n, int n2) {
        if (this.sections[n2] == null) {
            return false;
        }
        for (int i = 0; i < this.sections[n2].size(); ++i) {
            Record record = (Record)this.sections[n2].get(i);
            if (record.getType() != n || !name.equals(record.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int n) {
        return this.findRRset(name, n, 1) || this.findRRset(name, n, 2) || this.findRRset(name, n, 3);
    }

    public Record getQuestion() {
        List list = this.sections[0];
        if (list == null || list.size() == 0) {
            return null;
        }
        return (Record)list.get(0);
    }

    public TSIGRecord getTSIG() {
        int n = this.header.getCount(3);
        if (n == 0) {
            return null;
        }
        List list = this.sections[3];
        Record record = (Record)list.get(n - 1);
        if (record.type != 250) {
            return null;
        }
        return (TSIGRecord)record;
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        Record[] recordArray = this.getSectionArray(3);
        for (int i = 0; i < recordArray.length; ++i) {
            if (!(recordArray[i] instanceof OPTRecord)) continue;
            return (OPTRecord)recordArray[i];
        }
        return null;
    }

    public int getRcode() {
        int n = this.header.getRcode();
        OPTRecord oPTRecord = this.getOPT();
        if (oPTRecord != null) {
            n += oPTRecord.getExtendedRcode() << 4;
        }
        return n;
    }

    public Record[] getSectionArray(int n) {
        if (this.sections[n] == null) {
            return emptyRecordArray;
        }
        List list = this.sections[n];
        return list.toArray(new Record[list.size()]);
    }

    private static boolean sameSet(Record record, Record record2) {
        return record.getRRsetType() == record2.getRRsetType() && record.getDClass() == record2.getDClass() && record.getName().equals(record2.getName());
    }

    public RRset[] getSectionRRsets(int n) {
        if (this.sections[n] == null) {
            return emptyRRsetArray;
        }
        LinkedList<RRset> linkedList = new LinkedList<RRset>();
        Record[] recordArray = this.getSectionArray(n);
        HashSet<Name> hashSet = new HashSet<Name>();
        for (int i = 0; i < recordArray.length; ++i) {
            Name name = recordArray[i].getName();
            boolean bl = true;
            if (hashSet.contains(name)) {
                for (int j = linkedList.size() - 1; j >= 0; --j) {
                    RRset rRset = (RRset)linkedList.get(j);
                    if (rRset.getType() != recordArray[i].getRRsetType() || rRset.getDClass() != recordArray[i].getDClass() || !rRset.getName().equals(name)) continue;
                    rRset.addRR(recordArray[i]);
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            RRset rRset = new RRset(recordArray[i]);
            linkedList.add(rRset);
            hashSet.add(name);
        }
        return linkedList.toArray(new RRset[linkedList.size()]);
    }

    void toWire(DNSOutput dNSOutput) {
        this.header.toWire(dNSOutput);
        Compression compression = new Compression();
        for (int i = 0; i < 4; ++i) {
            if (this.sections[i] == null) continue;
            for (int j = 0; j < this.sections[i].size(); ++j) {
                Record record = (Record)this.sections[i].get(j);
                record.toWire(dNSOutput, i, compression);
            }
        }
    }

    private int sectionToWire(DNSOutput dNSOutput, int n, Compression compression, int n2) {
        int n3 = this.sections[n].size();
        int n4 = dNSOutput.current();
        int n5 = 0;
        Record record = null;
        for (int i = 0; i < n3; ++i) {
            Record record2 = (Record)this.sections[n].get(i);
            if (record != null && !Message.sameSet(record2, record)) {
                n4 = dNSOutput.current();
                n5 = i;
            }
            record = record2;
            record2.toWire(dNSOutput, n, compression);
            if (dNSOutput.current() <= n2) continue;
            dNSOutput.jump(n4);
            return n3 - n5;
        }
        return 0;
    }

    private boolean toWire(DNSOutput dNSOutput, int n) {
        if (n < 12) {
            return false;
        }
        Header header = null;
        int n2 = n;
        if (this.tsigkey != null) {
            n2 -= this.tsigkey.recordLength();
        }
        int n3 = dNSOutput.current();
        this.header.toWire(dNSOutput);
        Compression compression = new Compression();
        for (int i = 0; i < 4; ++i) {
            int n4;
            if (this.sections[i] == null || (n4 = this.sectionToWire(dNSOutput, i, compression, n2)) == 0) continue;
            if (header == null) {
                header = (Header)this.header.clone();
            }
            if (i != 3) {
                header.setFlag(6);
            }
            int n5 = header.getCount(i);
            header.setCount(i, n5 - n4);
            for (int j = i + 1; j < 4; ++j) {
                header.setCount(j, 0);
            }
            dNSOutput.save();
            dNSOutput.jump(n3);
            header.toWire(dNSOutput);
            dNSOutput.restore();
            break;
        }
        if (this.tsigkey != null) {
            TSIGRecord tSIGRecord = this.tsigkey.generate(this, dNSOutput.toByteArray(), this.tsigerror, this.querytsig);
            if (header == null) {
                header = (Header)this.header.clone();
            }
            tSIGRecord.toWire(dNSOutput, 3, compression);
            header.incCount(3);
            dNSOutput.save();
            dNSOutput.jump(n3);
            header.toWire(dNSOutput);
            dNSOutput.restore();
        }
        return true;
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        this.size = dNSOutput.current();
        return dNSOutput.toByteArray();
    }

    public byte[] toWire(int n) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, n);
        this.size = dNSOutput.current();
        return dNSOutput.toByteArray();
    }

    public void setTSIG(TSIG tSIG, int n, TSIGRecord tSIGRecord) {
        this.tsigkey = tSIG;
        this.tsigerror = n;
        this.querytsig = tSIGRecord;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int n) {
        if (n > 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Record[] recordArray = this.getSectionArray(n);
        for (int i = 0; i < recordArray.length; ++i) {
            Record record = recordArray[i];
            if (n == 0) {
                stringBuffer.append(";;\t" + record.name);
                stringBuffer.append(", type = " + Type.string(record.type));
                stringBuffer.append(", class = " + DClass.string(record.dclass));
            } else {
                stringBuffer.append(record);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        OPTRecord oPTRecord = this.getOPT();
        if (oPTRecord != null) {
            stringBuffer.append(this.header.toStringWithRcode(this.getRcode()) + "\n");
        } else {
            stringBuffer.append(this.header + "\n");
        }
        if (this.isSigned()) {
            stringBuffer.append(";; TSIG ");
            if (this.isVerified()) {
                stringBuffer.append("ok");
            } else {
                stringBuffer.append("invalid");
            }
            stringBuffer.append('\n');
        }
        for (int i = 0; i < 4; ++i) {
            if (this.header.getOpcode() != 5) {
                stringBuffer.append(";; " + Section.longString(i) + ":\n");
            } else {
                stringBuffer.append(";; " + Section.updString(i) + ":\n");
            }
            stringBuffer.append(this.sectionToString(i) + "\n");
        }
        stringBuffer.append(";; Message size: " + this.numBytes() + " bytes");
        return stringBuffer.toString();
    }

    public Object clone() {
        Message message = new Message();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            message.sections[i] = new LinkedList(this.sections[i]);
        }
        message.header = (Header)this.header.clone();
        message.size = this.size;
        return message;
    }
}

