/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jlibrtp.jlibrtp.core.AppCallerThread;
import org.jlibrtp.jlibrtp.core.DebugAppIntf;
import org.jlibrtp.jlibrtp.core.Participant;
import org.jlibrtp.jlibrtp.core.ParticipantDatabase;
import org.jlibrtp.jlibrtp.core.RTCPAVPFIntf;
import org.jlibrtp.jlibrtp.core.RTCPAppIntf;
import org.jlibrtp.jlibrtp.core.RTCPSession;
import org.jlibrtp.jlibrtp.core.RTPAppIntf;
import org.jlibrtp.jlibrtp.core.RTPReceiverThread;
import org.jlibrtp.jlibrtp.core.RtcpPktAPP;
import org.jlibrtp.jlibrtp.core.RtcpPktPSFB;
import org.jlibrtp.jlibrtp.core.RtcpPktRTPFB;
import org.jlibrtp.jlibrtp.core.RtpPkt;

public class RTPSession {
    public static final int rtpDebugLevel = 0;
    public static final int rtcpDebugLevel = 0;
    protected DatagramSocket rtpSock = null;
    protected MulticastSocket rtpMCSock = null;
    protected InetAddress mcGroup = null;
    protected boolean mcSession = false;
    protected int payloadType = 0;
    protected long ssrc;
    protected long lastTimestamp = 0L;
    protected int seqNum = 0;
    protected int sentPktCount = 0;
    protected int sentOctetCount = 0;
    protected Random random = null;
    protected int bandwidth = 8000;
    protected boolean naiveReception = false;
    protected boolean frameReconstruction = true;
    protected int pktBufBehavior = 3;
    protected ParticipantDatabase partDb = new ParticipantDatabase(this);
    protected RTPAppIntf appIntf = null;
    protected RTCPAppIntf rtcpAppIntf = null;
    protected RTCPAVPFIntf rtcpAVPFIntf = null;
    protected DebugAppIntf debugAppIntf = null;
    protected RTCPSession rtcpSession = null;
    protected RTPReceiverThread recvThrd = null;
    protected AppCallerThread appCallerThrd = null;
    protected final Lock pktBufLock = new ReentrantLock();
    protected final Condition pktBufDataReady = this.pktBufLock.newCondition();
    protected boolean endSession = false;
    protected boolean registered = false;
    protected boolean conflict = false;
    protected int conflictCount = 0;
    protected String cname = null;
    public String name = null;
    public String email = null;
    public String phone = null;
    public String loc = null;
    public String tool = null;
    public String note = null;
    public String priv = null;
    protected int rtcpMode = 0;
    protected int fbEarlyThreshold = -1;
    protected int fbRegularThreshold = -1;
    protected int minInterval = 5000;
    protected int fbMaxDelay = 1000;
    protected int rtcpBandwidth = -1;

    public RTPSession(DatagramSocket rtpSocket, DatagramSocket rtcpSocket) {
        this.mcSession = false;
        this.rtpSock = rtpSocket;
        this.generateCNAME();
        this.generateSsrc();
        this.rtcpSession = new RTCPSession(this, rtcpSocket);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            System.out.println("RTPSession sleep failed");
        }
    }

    public RTPSession(MulticastSocket rtpSock, MulticastSocket rtcpSock, InetAddress multicastGroup) throws Exception {
        this.mcSession = true;
        this.rtpMCSock = rtpSock;
        this.mcGroup = multicastGroup;
        this.rtpMCSock.joinGroup(this.mcGroup);
        rtcpSock.joinGroup(this.mcGroup);
        this.generateCNAME();
        this.generateSsrc();
        this.rtcpSession = new RTCPSession(this, rtcpSock, this.mcGroup);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            System.out.println("RTPSession sleep failed");
        }
    }

    public int RTPSessionRegister(RTPAppIntf rtpApp, RTCPAppIntf rtcpApp, DebugAppIntf debugApp) {
        if (this.registered) {
            System.out.println("RTPSessionRegister(): Can't register another application!");
            return -1;
        }
        this.registered = true;
        this.generateSeqNum();
        this.appIntf = rtpApp;
        this.rtcpAppIntf = rtcpApp;
        this.debugAppIntf = debugApp;
        this.recvThrd = new RTPReceiverThread(this);
        this.appCallerThrd = new AppCallerThread(this, rtpApp);
        this.recvThrd.start();
        this.appCallerThrd.start();
        this.rtcpSession.start();
        return 0;
    }

    public long[] sendData(byte[] buf) {
        byte[][] tmp = new byte[][]{buf};
        long[][] ret = this.sendData(tmp, null, null, -1L, null);
        if (ret != null) {
            return ret[0];
        }
        return null;
    }

    public long[] sendData(byte[] buf, long rtpTimestamp, long seqNum) {
        byte[][] tmp = new byte[][]{buf};
        long[][] ret = this.sendData(tmp, null, null, -1L, null);
        if (ret != null) {
            return ret[0];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public long[][] sendData(byte[][] buffers, long[] csrcArray, boolean[] markers, long rtpTimestamp, long[] seqNumbers) {
        if (rtpTimestamp < 0L) {
            rtpTimestamp = System.currentTimeMillis();
        }
        ret = new long[buffers.length][2];
        i = 0;
        while (i < buffers.length) {
            buf = buffers[i];
            marker = false;
            if (markers != null) {
                marker = markers[i];
            }
            if (buf.length > 1500) {
                System.out.println("RTPSession.sendData() called with buffer exceeding 1500 bytes (" + buf.length + ")");
            }
            ret[i][0] = rtpTimestamp;
            ret[i][1] = seqNumbers == null ? (long)this.getNextSeqNum() : seqNumbers[i];
            pkt = new RtpPkt(rtpTimestamp, this.ssrc, (int)ret[i][1], this.payloadType, buf);
            if (csrcArray != null) {
                pkt.setCsrcs(csrcArray);
            }
            pkt.setMarked(marker);
            pktBytes = pkt.encode();
            if (this.conflict) {
                System.out.println("RTPSession.sendData() called while trying to resolve conflict.");
                return null;
            }
            if (this.mcSession) {
                packet = null;
                try {
                    packet = new DatagramPacket(pktBytes, pktBytes.length, this.mcGroup, this.rtpMCSock.getPort());
                }
                catch (Exception e) {
                    System.out.println("RTPSession.sendData() packet creation failed.");
                    e.printStackTrace();
                    return null;
                }
                try {
                    this.rtpMCSock.send(packet);
                    if (this.debugAppIntf == null) ** GOTO lbl61
                    this.debugAppIntf.packetSent(1, (InetSocketAddress)packet.getSocketAddress(), new String("Sent multicast RTP packet of size " + packet.getLength() + " to " + packet.getSocketAddress().toString() + " via " + this.rtpMCSock.getLocalSocketAddress().toString()));
                }
                catch (Exception e) {
                    System.out.println("RTPSession.sendData() multicast failed.");
                    e.printStackTrace();
                    return null;
                }
            } else {
                iter = this.partDb.getUnicastReceivers();
                while (iter.hasNext()) {
                    receiver = ((Participant)iter.next()).rtpAddress;
                    packet = null;
                    try {
                        packet = new DatagramPacket(pktBytes, pktBytes.length, receiver);
                    }
                    catch (Exception e) {
                        System.out.println("RTPSession.sendData() packet creation failed.");
                        e.printStackTrace();
                        return null;
                    }
                    try {
                        this.rtpSock.send(packet);
                        if (this.debugAppIntf == null) continue;
                        this.debugAppIntf.packetSent(0, (InetSocketAddress)packet.getSocketAddress(), new String("Sent unicast RTP packet of size " + packet.getLength() + " to " + packet.getSocketAddress().toString() + " via " + this.rtpSock.getLocalSocketAddress().toString()));
                    }
                    catch (Exception e) {
                        System.out.println("RTPSession.sendData() unicast failed.");
                        e.printStackTrace();
                        return null;
                    }
                }
            }
lbl61:
            // 3 sources

            ++this.sentPktCount;
            ++this.sentOctetCount;
            ++i;
        }
        return ret;
    }

    public int sendRTCPAppPacket(long ssrc, int type, byte[] name, byte[] data) {
        if (this.rtcpSession == null) {
            return -1;
        }
        if (name.length != 4) {
            return -2;
        }
        if (data.length % 4 != 0) {
            return -3;
        }
        if (type > 63 || type < 0) {
            return -4;
        }
        RtcpPktAPP pkt = new RtcpPktAPP(ssrc, type, name, data);
        this.rtcpSession.addToAppQueue(ssrc, pkt);
        return 0;
    }

    public int addParticipant(Participant p) {
        p.unexpected = false;
        return this.partDb.addParticipant(0, p);
    }

    public void removeParticipant(Participant p) {
        this.partDb.removeParticipant(p);
    }

    public Iterator<Participant> getUnicastReceivers() {
        return this.partDb.getUnicastReceivers();
    }

    public Enumeration<Participant> getParticipants() {
        return this.partDb.getParticipants();
    }

    public void endSession() {
        this.endSession = true;
        if (this.mcSession) {
            this.rtpMCSock.close();
        } else {
            this.rtpSock.close();
        }
        this.pktBufLock.lock();
        try {
            this.pktBufDataReady.signalAll();
        }
        finally {
            this.pktBufLock.unlock();
        }
        this.rtcpSession.senderThrd.interrupt();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.appCallerThrd.interrupt();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.rtcpSession != null) {
            if (this.mcSession) {
                this.rtcpSession.rtcpMCSock.close();
            } else {
                this.rtcpSession.rtcpSock.close();
            }
        }
    }

    boolean isEnding() {
        return this.endSession;
    }

    public void CNAME(String cname) {
        this.cname = cname;
    }

    public String CNAME() {
        return this.cname;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    private void generateCNAME() {
        String hostname = this.mcSession ? this.rtpMCSock.getLocalAddress().getCanonicalHostName() : this.rtpSock.getLocalAddress().getCanonicalHostName();
        this.cname = String.valueOf(System.getProperty("user.name")) + "@" + hostname;
    }

    public int updateRTPSock(DatagramSocket newSock) {
        if (!this.mcSession) {
            this.rtpSock = newSock;
            return 0;
        }
        System.out.println("Can't switch from multicast to unicast.");
        return -1;
    }

    public int updateRTCPSock(DatagramSocket newSock) {
        if (!this.mcSession) {
            this.rtcpSession.rtcpSock = newSock;
            return 0;
        }
        System.out.println("Can't switch from multicast to unicast.");
        return -1;
    }

    public int updateRTPSock(MulticastSocket newSock) {
        if (this.mcSession) {
            this.rtpMCSock = newSock;
            return 0;
        }
        System.out.println("Can't switch from unicast to multicast.");
        return -1;
    }

    public int updateRTCPSock(MulticastSocket newSock) {
        if (this.mcSession) {
            this.rtcpSession.rtcpMCSock = newSock;
            return 0;
        }
        System.out.println("Can't switch from unicast to multicast.");
        return -1;
    }

    public int payloadType(int payloadT) {
        if (payloadT > 128 || payloadT < 0) {
            return -1;
        }
        this.payloadType = payloadT;
        return this.payloadType;
    }

    public int payloadType() {
        return this.payloadType;
    }

    public void naivePktReception(boolean doAccept) {
        this.naiveReception = doAccept;
    }

    public boolean naivePktReception() {
        return this.naiveReception;
    }

    public int packetBufferBehavior(int behavior) {
        if (behavior > -2) {
            this.pktBufBehavior = behavior;
            this.pktBufLock.lock();
            try {
                this.pktBufDataReady.signalAll();
            }
            finally {
                this.pktBufLock.unlock();
            }
            return this.pktBufBehavior;
        }
        return this.pktBufBehavior;
    }

    public int packetBufferBehavior() {
        return this.pktBufBehavior;
    }

    public int registerAVPFIntf(RTCPAVPFIntf rtcpAVPFIntf, int maxDelay, int earlyThreshold, int regularThreshold) {
        if (this.rtcpSession != null) {
            this.packetBufferBehavior(-1);
            this.frameReconstruction = false;
            this.rtcpAVPFIntf = rtcpAVPFIntf;
            this.fbEarlyThreshold = earlyThreshold;
            this.fbRegularThreshold = regularThreshold;
            return 0;
        }
        return -1;
    }

    public void unregisterAVPFIntf() {
        this.fbEarlyThreshold = -1;
        this.fbRegularThreshold = -1;
        this.rtcpAVPFIntf = null;
    }

    public void frameReconstruction(boolean toggle) {
        this.frameReconstruction = toggle;
    }

    public boolean frameReconstruction() {
        return this.frameReconstruction;
    }

    public int sessionBandwidth() {
        return this.bandwidth;
    }

    public int sessionBandwidth(int bandwidth) {
        this.bandwidth = bandwidth < 1 ? 8000 : bandwidth;
        return this.bandwidth;
    }

    public int rtcpBandwidth() {
        return this.rtcpBandwidth;
    }

    public int rtcpBandwidth(int bandwidth) {
        this.rtcpBandwidth = bandwidth < -1 ? -1 : bandwidth;
        return this.rtcpBandwidth;
    }

    public int fbPictureLossIndication(long ssrcMediaSource) {
        int ret = 0;
        if (this.rtcpAVPFIntf == null) {
            return -1;
        }
        RtcpPktPSFB pkt = new RtcpPktPSFB(this.ssrc, ssrcMediaSource);
        pkt.makePictureLossIndication();
        ret = this.rtcpSession.addToFbQueue(ssrcMediaSource, pkt);
        if (ret == 0) {
            this.rtcpSession.wakeSenderThread(ssrcMediaSource);
        }
        return ret;
    }

    public int fbSlicLossIndication(long ssrcMediaSource, int[] sliFirst, int[] sliNumber, int[] sliPictureId) {
        int ret = 0;
        if (this.rtcpAVPFIntf == null) {
            return -1;
        }
        RtcpPktPSFB pkt = new RtcpPktPSFB(this.ssrc, ssrcMediaSource);
        pkt.makeSliceLossIndication(sliFirst, sliNumber, sliPictureId);
        ret = this.rtcpSession.addToFbQueue(ssrcMediaSource, pkt);
        if (ret == 0) {
            this.rtcpSession.wakeSenderThread(ssrcMediaSource);
        }
        return ret;
    }

    public int fbRefPictureSelIndic(long ssrcMediaSource, int bitPadding, int payloadType, byte[] bitString) {
        int ret = 0;
        if (this.rtcpAVPFIntf == null) {
            return -1;
        }
        RtcpPktPSFB pkt = new RtcpPktPSFB(this.ssrc, ssrcMediaSource);
        pkt.makeRefPictureSelIndic(bitPadding, payloadType, bitString);
        ret = this.rtcpSession.addToFbQueue(ssrcMediaSource, pkt);
        if (ret == 0) {
            this.rtcpSession.wakeSenderThread(ssrcMediaSource);
        }
        return ret;
    }

    public int fbAppLayerFeedback(long ssrcMediaSource, byte[] bitString) {
        int ret = 0;
        if (this.rtcpAVPFIntf == null) {
            return -1;
        }
        RtcpPktPSFB pkt = new RtcpPktPSFB(this.ssrc, ssrcMediaSource);
        pkt.makeAppLayerFeedback(bitString);
        ret = this.rtcpSession.addToFbQueue(ssrcMediaSource, pkt);
        if (ret == 0) {
            this.rtcpSession.wakeSenderThread(ssrcMediaSource);
        }
        return ret;
    }

    public int fbPictureLossIndication(long ssrcMediaSource, int FMT, int[] PID, int[] BLP) {
        int ret = 0;
        if (this.rtcpAVPFIntf == null) {
            return -1;
        }
        RtcpPktRTPFB pkt = new RtcpPktRTPFB(this.ssrc, ssrcMediaSource, FMT, PID, BLP);
        ret = this.rtcpSession.addToFbQueue(ssrcMediaSource, pkt);
        if (ret == 0) {
            this.rtcpSession.wakeSenderThread(ssrcMediaSource);
        }
        return ret;
    }

    private int getNextSeqNum() {
        ++this.seqNum;
        if (this.seqNum > 65536) {
            this.seqNum = 0;
        }
        return this.seqNum;
    }

    private void createRandom() {
        this.random = new Random(System.currentTimeMillis() + Thread.currentThread().getId() - (long)Thread.currentThread().hashCode() + (long)this.cname.hashCode());
    }

    private void generateSeqNum() {
        if (this.random == null) {
            this.createRandom();
        }
        this.seqNum = this.random.nextInt();
        if (this.seqNum < 0) {
            this.seqNum = -this.seqNum;
        }
        while (this.seqNum > 65535) {
            this.seqNum /= 10;
        }
    }

    private void generateSsrc() {
        if (this.random == null) {
            this.createRandom();
        }
        this.ssrc = this.random.nextInt();
        if (this.ssrc < 0L) {
            this.ssrc *= -1L;
        }
    }

    protected void resolveSsrcConflict() {
        System.out.println("!!!!!!! Beginning SSRC conflict resolution !!!!!!!!!");
        ++this.conflictCount;
        if (this.conflictCount < 5) {
            this.conflict = true;
            this.rtcpSession.sendByes();
            this.rtcpSession.calculateDelay();
            this.generateSsrc();
            this.rtcpSession.initial = true;
            this.conflict = false;
            System.out.println("SSRC conflict resolution complete");
        } else {
            System.out.println("Too many conflicts. There is probably a loop in the network.");
            this.endSession();
        }
    }
}

