/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class A6Record
extends Record {
    private static final long serialVersionUID = -8815026887337346789L;
    private int prefixBits;
    private InetAddress suffix;
    private Name prefix;

    A6Record() {
    }

    @Override
    Record getObject() {
        return new A6Record();
    }

    public A6Record(Name name, int n, long l, int n2, InetAddress inetAddress, Name name2) {
        super(name, 38, n, l);
        this.prefixBits = A6Record.checkU8("prefixBits", n2);
        if (inetAddress != null && Address.familyOf(inetAddress) != 2) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.suffix = inetAddress;
        if (name2 != null) {
            this.prefix = A6Record.checkName("prefix", name2);
        }
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.prefixBits = dNSInput.readU8();
        int n = 128 - this.prefixBits;
        int n2 = (n + 7) / 8;
        if (this.prefixBits < 128) {
            byte[] byArray = new byte[16];
            dNSInput.readByteArray(byArray, 16 - n2, n2);
            this.suffix = InetAddress.getByAddress(byArray);
        }
        if (this.prefixBits > 0) {
            this.prefix = new Name(dNSInput);
        }
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.prefixBits = tokenizer.getUInt8();
        if (this.prefixBits > 128) {
            throw tokenizer.exception("prefix bits must be [0..128]");
        }
        if (this.prefixBits < 128) {
            String string = tokenizer.getString();
            try {
                this.suffix = Address.getByAddress(string, 2);
            }
            catch (UnknownHostException unknownHostException) {
                throw tokenizer.exception("invalid IPv6 address: " + string);
            }
        }
        if (this.prefixBits > 0) {
            this.prefix = tokenizer.getName(name);
        }
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.prefixBits);
        if (this.suffix != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.suffix.getHostAddress());
        }
        if (this.prefix != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.prefix);
        }
        return stringBuffer.toString();
    }

    public int getPrefixBits() {
        return this.prefixBits;
    }

    public InetAddress getSuffix() {
        return this.suffix;
    }

    public Name getPrefix() {
        return this.prefix;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU8(this.prefixBits);
        if (this.suffix != null) {
            int n = 128 - this.prefixBits;
            int n2 = (n + 7) / 8;
            byte[] byArray = this.suffix.getAddress();
            dNSOutput.writeByteArray(byArray, 16 - n2, n2);
        }
        if (this.prefix != null) {
            this.prefix.toWire(dNSOutput, null, bl);
        }
    }
}

