/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Thread keepAliveThread;
    private Writer writer;
    private XMPPConnection connection;
    private final BlockingQueue<Packet> queue;
    private boolean done;
    private long lastActive = System.currentTimeMillis();

    protected PacketWriter(XMPPConnection xMPPConnection) {
        this.queue = new ArrayBlockingQueue<Packet>(500, true);
        this.connection = xMPPConnection;
        this.init();
    }

    protected void init() {
        this.writer = this.connection.writer;
        this.done = false;
        this.writerThread = new Thread(){

            @Override
            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.connectionCounterValue + ")");
        this.writerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.connection.firePacketInterceptors(packet);
            try {
                this.queue.put(packet);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            BlockingQueue<Packet> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            this.connection.firePacketSendingListeners(packet);
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void startKeepAliveProcess() {
        int n = SmackConfiguration.getKeepAliveInterval();
        if (n > 0) {
            KeepAliveTask keepAliveTask = new KeepAliveTask(n);
            this.keepAliveThread = new Thread(keepAliveTask);
            keepAliveTask.setThread(this.keepAliveThread);
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.setName("Smack Keep Alive (" + this.connection.connectionCounterValue + ")");
            this.keepAliveThread.start();
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.done = true;
        BlockingQueue<Packet> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
        }
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
        }
    }

    void cleanup() {
        this.connection.interceptors.clear();
        this.connection.sendListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet nextPacket() {
        Packet packet = null;
        while (!this.done && (packet = (Packet)this.queue.poll()) == null) {
            try {
                BlockingQueue<Packet> blockingQueue = this.queue;
                synchronized (blockingQueue) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackets(Thread thread) {
        block24: {
            try {
                Object object;
                Object object2;
                this.openStream();
                while (!this.done && this.writerThread == thread) {
                    object2 = this.nextPacket();
                    if (object2 == null) continue;
                    object = this.writer;
                    synchronized (object) {
                        this.writer.write(((Packet)object2).toXML());
                        this.writer.flush();
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                try {
                    object2 = this.writer;
                    synchronized (object2) {
                        while (!this.queue.isEmpty()) {
                            object = (Packet)this.queue.remove();
                            this.writer.write(((Packet)object).toXML());
                        }
                        this.writer.flush();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.queue.clear();
                try {
                    this.writer.write("</stream:stream>");
                    this.writer.flush();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException iOException) {
                if (this.done || this.connection.isSocketClosed()) break block24;
                this.done = true;
                if (this.connection.packetReader == null) break block24;
                this.connection.packetReader.notifyConnectionError(iOException);
            }
        }
    }

    void openStream() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<stream:stream");
        stringBuilder.append(" to=\"").append(this.connection.getServiceName()).append("\"");
        stringBuilder.append(" xmlns=\"jabber:client\"");
        stringBuilder.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stringBuilder.append(" version=\"1.0\">");
        this.writer.write(stringBuilder.toString());
        this.writer.flush();
    }

    private class KeepAliveTask
    implements Runnable {
        private int delay;
        private Thread thread;

        public KeepAliveTask(int n) {
            this.delay = n;
        }

        protected void setThread(Thread thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(15000 + this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!PacketWriter.this.done && PacketWriter.this.keepAliveThread == this.thread) {
                Writer writer = PacketWriter.this.writer;
                synchronized (writer) {
                    if (System.currentTimeMillis() - PacketWriter.this.lastActive >= (long)this.delay) {
                        try {
                            PacketWriter.this.writer.write(" ");
                            PacketWriter.this.writer.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

