/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class Subscription
extends NodeExtension {
    protected String jid;
    protected String id;
    protected State state;
    protected boolean configRequired = false;

    public Subscription(String string) {
        this(string, null, null, null);
    }

    public Subscription(String string, String string2) {
        this(string, string2, null, null);
    }

    public Subscription(String string, String string2, String string3, State state) {
        super(PubSubElementType.SUBSCRIPTION, string2);
        this.jid = string;
        this.id = string3;
        this.state = state;
    }

    public Subscription(String string, String string2, String string3, State state, boolean bl) {
        super(PubSubElementType.SUBSCRIPTION, string2);
        this.jid = string;
        this.id = string3;
        this.state = state;
        this.configRequired = bl;
    }

    public String getJid() {
        return this.jid;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConfigRequired() {
        return this.configRequired;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder("<subscription");
        this.appendAttribute(stringBuilder, "jid", this.jid);
        if (this.getNode() != null) {
            this.appendAttribute(stringBuilder, "node", this.getNode());
        }
        if (this.id != null) {
            this.appendAttribute(stringBuilder, "subid", this.id);
        }
        if (this.state != null) {
            this.appendAttribute(stringBuilder, "subscription", this.state.toString());
        }
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    private void appendAttribute(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(" ");
        stringBuilder.append(string);
        stringBuilder.append("='");
        stringBuilder.append(string2);
        stringBuilder.append("'");
    }

    public static enum State {
        subscribed,
        unconfigured,
        pending,
        none;

    }
}

