/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.media;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.MediaReceivedListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

public abstract class JingleMediaSession {
    private PayloadType payloadType;
    private TransportCandidate local;
    private TransportCandidate remote;
    private String mediaLocator;
    private List<MediaReceivedListener> mediaReceivedListeners = new ArrayList<MediaReceivedListener>();
    private JingleSession jingleSession;

    public JingleMediaSession(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2, String string, JingleSession jingleSession) {
        this.local = transportCandidate2;
        this.remote = transportCandidate;
        this.payloadType = payloadType;
        this.mediaLocator = string;
        this.jingleSession = jingleSession;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public TransportCandidate getLocal() {
        return this.local;
    }

    public TransportCandidate getRemote() {
        return this.remote;
    }

    public String getMediaLocator() {
        return this.mediaLocator;
    }

    public void setMediaLocator(String string) {
        this.mediaLocator = string;
    }

    public void addMediaReceivedListener(MediaReceivedListener mediaReceivedListener) {
        this.mediaReceivedListeners.add(mediaReceivedListener);
    }

    public void removeMediaReceivedListener(MediaReceivedListener mediaReceivedListener) {
        this.mediaReceivedListeners.remove(mediaReceivedListener);
    }

    public void removeAllMediaReceivedListener() {
        this.mediaReceivedListeners.clear();
    }

    public abstract void initialize();

    public abstract void startTrasmit();

    public abstract void startReceive();

    public abstract void setTrasmit(boolean var1);

    public abstract void stopTrasmit();

    public abstract void stopReceive();

    public void mediaReceived(String string) {
        for (MediaReceivedListener mediaReceivedListener : this.mediaReceivedListeners) {
            mediaReceivedListener.mediaReceived(string);
        }
    }

    public JingleSession getJingleSession() {
        return this.jingleSession;
    }
}

