/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.SubscriptionEvent;

public class ItemPublishEvent<T extends Item>
extends SubscriptionEvent {
    private List<T> items;
    private Date originalDate;

    public ItemPublishEvent(String string, List<T> list) {
        super(string);
        this.items = list;
    }

    public ItemPublishEvent(String string, List<T> list, List<String> list2) {
        super(string, list2);
        this.items = list;
    }

    public ItemPublishEvent(String string, List<T> list, List<String> list2, Date date) {
        super(string, list2);
        this.items = list;
        if (date != null) {
            this.originalDate = date;
        }
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public boolean isDelayed() {
        return this.originalDate != null;
    }

    public Date getPublishedDate() {
        return this.originalDate;
    }

    public String toString() {
        return this.getClass().getName() + "  [subscriptions: " + this.getSubscriptions() + "], [Delayed: " + (this.isDelayed() ? this.originalDate.toString() : "false") + ']';
    }
}

