package com.beem.project.beem.ui.dialogs.builders;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.RemoteException;
import android.util.Log;

import com.beem.project.beem.R;
import com.beem.project.beem.service.aidl.IPrivacyListManager;

public class DeletePrivacyList extends AlertDialog.Builder {

    private static final String TAG = "Dialogs.Builders > DeletePrivacyList";

    private final IPrivacyListManager mPrivacyListManager;
    private final String mPrivacyListName;

    /**
     * Constructor.
     * @param context context activity.
     */
    public DeletePrivacyList(final Context context, IPrivacyListManager privacyListManager, String privacyListName) {
	super(context);

	mPrivacyListManager = privacyListManager;
	mPrivacyListName = privacyListName;

	setMessage(context.getString(R.string.privacy_list_delete_dialog_msg, privacyListName));
	DialogClickListener dl = new DialogClickListener();
	setPositiveButton(R.string.privacy_list_delete_dialog_yes, dl);
	setNegativeButton(R.string.privacy_list_delete_dialog_no, dl);
    }

    /**
     * Event click listener.
     */
    private class DialogClickListener implements DialogInterface.OnClickListener {

	/**
	 * Constructor.
	 */
	public DialogClickListener() {
	}

	@Override
	public void onClick(DialogInterface dialog, int which) {
	    if (which == DialogInterface.BUTTON_POSITIVE) {
		try {
		    mPrivacyListManager.removePrivacyList(mPrivacyListName);
		} catch (RemoteException e) {
		    Log.e(TAG, e.getMessage());
		}
	    }
	}
    }
}
