package com.beem.project.beem.jingle;

import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;

/**
 * Transmit Microphone data through RTP.
 * 
 * @author nikita
 */
public class PCMTransmitter extends RTPTransmitter {

	private static final int BUFF_SIZE = 1024;
	private static final int RATE_IN_HZ = 8000;
	private static final int SLP_DURATION = 200;

	/**
	 * Constructor.
	 * 
	 * @param remoteIP
	 *            receiver IP.
	 * @param remotePort
	 *            receiver port.
	 */
	public PCMTransmitter(final String remoteIP, final int remotePort) {
		super(remoteIP, remotePort);
	}

	@Override
	void start() {
		AudioRecord audRec = new AudioRecord(MediaRecorder.AudioSource.DEFAULT, RATE_IN_HZ,
				AudioFormat.CHANNEL_CONFIGURATION_MONO, AudioFormat.ENCODING_PCM_16BIT, AudioRecord.getMinBufferSize(
						RATE_IN_HZ, AudioFormat.CHANNEL_CONFIGURATION_MONO, AudioFormat.ENCODING_PCM_16BIT) * 4);
		byte[] audioData = new byte[BUFF_SIZE];
		int byteReaded = 0;
		while (!isKillme()) {
			byteReaded = audRec.read(audioData, byteReaded, BUFF_SIZE);
			System.out.println("readed " + byteReaded);
			getRtpSession().sendData(audioData);
		}
		try {
			Thread.sleep(SLP_DURATION);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		this.getRtpSession().endSession();
	}
}
