/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class OccupantsInfo
extends IQ {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static final String ELEMENT_NAME = "occupants-info";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private String roomID;
    private final Set<OccupantInfo> occupants;

    public OccupantsInfo(String string) {
        this.roomID = string;
        this.occupants = new HashSet<OccupantInfo>();
    }

    public String getRoomID() {
        return this.roomID;
    }

    public int getOccupantsCount() {
        return this.occupants.size();
    }

    public Set<OccupantInfo> getOccupants() {
        return Collections.unmodifiableSet(this.occupants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE);
        stringBuilder.append("\" roomID=\"").append(this.roomID).append("\">");
        Set<OccupantInfo> set = this.occupants;
        synchronized (set) {
            for (OccupantInfo occupantInfo : this.occupants) {
                stringBuilder.append("<occupant>");
                stringBuilder.append("<jid>");
                stringBuilder.append(occupantInfo.getJID());
                stringBuilder.append("</jid>");
                stringBuilder.append("<name>");
                stringBuilder.append(occupantInfo.getNickname());
                stringBuilder.append("</name>");
                stringBuilder.append("<joined>");
                stringBuilder.append(UTC_FORMAT.format(occupantInfo.getJoined()));
                stringBuilder.append("</joined>");
                stringBuilder.append("</occupant>");
            }
        }
        stringBuilder.append("</").append(ELEMENT_NAME).append("> ");
        return stringBuilder.toString();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public static class Provider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            if (xmlPullParser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            OccupantsInfo occupantsInfo = new OccupantsInfo(xmlPullParser.getAttributeValue("", "roomID"));
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "occupant".equals(xmlPullParser.getName())) {
                    occupantsInfo.occupants.add(this.parseOccupantInfo(xmlPullParser));
                    continue;
                }
                if (n != 3 || !OccupantsInfo.ELEMENT_NAME.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return occupantsInfo;
        }

        private OccupantInfo parseOccupantInfo(XmlPullParser xmlPullParser) throws Exception {
            boolean bl = false;
            String string = null;
            String string2 = null;
            Date date = null;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "jid".equals(xmlPullParser.getName())) {
                    string = xmlPullParser.nextText();
                    continue;
                }
                if (n == 2 && "nickname".equals(xmlPullParser.getName())) {
                    string2 = xmlPullParser.nextText();
                    continue;
                }
                if (n == 2 && "joined".equals(xmlPullParser.getName())) {
                    date = UTC_FORMAT.parse(xmlPullParser.nextText());
                    continue;
                }
                if (n != 3 || !"occupant".equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return new OccupantInfo(string, string2, date);
        }
    }

    public static class OccupantInfo {
        private String jid;
        private String nickname;
        private Date joined;

        public OccupantInfo(String string, String string2, Date date) {
            this.jid = string;
            this.nickname = string2;
            this.joined = date;
        }

        public String getJID() {
            return this.jid;
        }

        public String getNickname() {
            return this.nickname;
        }

        public Date getJoined() {
            return this.joined;
        }
    }
}

