/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;

public class Socks5Proxy {
    private static Socks5Proxy socks5Server;
    private Socks5ServerProcess serverProcess;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private final Map<String, Socket> connectionMap = new ConcurrentHashMap<String, Socket>();
    private final List<String> allowedConnections = Collections.synchronizedList(new LinkedList());
    private final Set<String> localAddresses = Collections.synchronizedSet(new LinkedHashSet());

    private Socks5Proxy() {
        this.serverProcess = new Socks5ServerProcess();
        try {
            this.localAddresses.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static synchronized Socks5Proxy getSocks5Proxy() {
        if (socks5Server == null) {
            socks5Server = new Socks5Proxy();
        }
        if (SmackConfiguration.isLocalSocks5ProxyEnabled()) {
            socks5Server.start();
        }
        return socks5Server;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            if (SmackConfiguration.getLocalSocks5ProxyPort() < 0) {
                int n = Math.abs(SmackConfiguration.getLocalSocks5ProxyPort());
                for (int i = 0; i < 65535 - n; ++i) {
                    try {
                        this.serverSocket = new ServerSocket(n + i);
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
            } else {
                this.serverSocket = new ServerSocket(SmackConfiguration.getLocalSocks5ProxyPort());
            }
            if (this.serverSocket != null) {
                this.serverThread = new Thread(this.serverProcess);
                this.serverThread.start();
            }
        }
        catch (IOException iOException) {
            System.err.println("couldn't setup local SOCKS5 proxy on port " + SmackConfiguration.getLocalSocks5ProxyPort() + ": " + iOException.getMessage());
        }
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverThread != null && this.serverThread.isAlive()) {
            try {
                this.serverThread.interrupt();
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.serverThread = null;
        this.serverSocket = null;
    }

    public void addLocalAddress(String string) {
        if (string == null) {
            throw new IllegalArgumentException("address may not be null");
        }
        this.localAddresses.add(string);
    }

    public void removeLocalAddress(String string) {
        this.localAddresses.remove(string);
    }

    public List<String> getLocalAddresses() {
        return Collections.unmodifiableList(new ArrayList<String>(this.localAddresses));
    }

    public void replaceLocalAddresses(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.localAddresses.clear();
        this.localAddresses.addAll(list);
    }

    public int getPort() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    protected Socket getSocket(String string) {
        return this.connectionMap.get(string);
    }

    protected void addTransfer(String string) {
        this.allowedConnections.add(string);
    }

    protected void removeTransfer(String string) {
        this.allowedConnections.remove(string);
        this.connectionMap.remove(string);
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    private class Socks5ServerProcess
    implements Runnable {
        private Socks5ServerProcess() {
        }

        @Override
        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    if (Socks5Proxy.this.serverSocket.isClosed() || Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    socket = Socks5Proxy.this.serverSocket.accept();
                    this.establishConnection(socket);
                    continue;
                }
                catch (SocketException socketException) {
                    continue;
                }
                catch (Exception exception) {
                    try {
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                    continue;
                }
                break;
            }
        }

        private void establishConnection(Socket socket) throws XMPPException, IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            int n = dataInputStream.read();
            if (n != 5) {
                throw new XMPPException("Only SOCKS5 supported");
            }
            n = dataInputStream.read();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            byte[] byArray2 = new byte[2];
            byArray2[0] = 5;
            boolean bl = false;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                byArray2[1] = -1;
                dataOutputStream.write(byArray2);
                dataOutputStream.flush();
                throw new XMPPException("Authentication method not supported");
            }
            byArray2[1] = 0;
            dataOutputStream.write(byArray2);
            dataOutputStream.flush();
            byte[] byArray3 = Socks5Utils.receiveSocks5Message(dataInputStream);
            String string = new String(byArray3, 5, (int)byArray3[4]);
            if (!Socks5Proxy.this.allowedConnections.contains(string)) {
                byArray3[1] = 5;
                dataOutputStream.write(byArray3);
                dataOutputStream.flush();
                throw new XMPPException("Connection is not allowed");
            }
            byArray3[1] = 0;
            dataOutputStream.write(byArray3);
            dataOutputStream.flush();
            Socks5Proxy.this.connectionMap.put(string, socket);
        }
    }
}

