/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EmptyRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.UNKRecord;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base16;

public abstract class Record
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2694906050116005466L;
    protected Name name;
    protected int type;
    protected int dclass;
    protected long ttl;
    private static final DecimalFormat byteFormat = new DecimalFormat();

    protected Record() {
    }

    Record(Name name, int n, int n2, long l) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(n);
        DClass.check(n2);
        TTL.check(l);
        this.name = name;
        this.type = n;
        this.dclass = n2;
        this.ttl = l;
    }

    abstract Record getObject();

    private static final Record getEmptyRecord(Name name, int n, int n2, long l, boolean bl) {
        Record record;
        Record record2 = bl ? ((record = Type.getProto(n)) != null ? record.getObject() : new UNKRecord()) : new EmptyRecord();
        record2.name = name;
        record2.type = n;
        record2.dclass = n2;
        record2.ttl = l;
        return record2;
    }

    abstract void rrFromWire(DNSInput var1) throws IOException;

    private static Record newRecord(Name name, int n, int n2, long l, int n3, DNSInput dNSInput) throws IOException {
        Record record = Record.getEmptyRecord(name, n, n2, l, dNSInput != null);
        if (dNSInput != null) {
            if (dNSInput.remaining() < n3) {
                throw new WireParseException("truncated record");
            }
            dNSInput.setActive(n3);
            record.rrFromWire(dNSInput);
            if (dNSInput.remaining() > 0) {
                throw new WireParseException("invalid record length");
            }
            dNSInput.clearActive();
        }
        return record;
    }

    public static Record newRecord(Name name, int n, int n2, long l, int n3, byte[] byArray) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(n);
        DClass.check(n2);
        TTL.check(l);
        DNSInput dNSInput = byArray != null ? new DNSInput(byArray) : null;
        try {
            return Record.newRecord(name, n, n2, l, n3, dNSInput);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Record newRecord(Name name, int n, int n2, long l, byte[] byArray) {
        return Record.newRecord(name, n, n2, l, byArray.length, byArray);
    }

    public static Record newRecord(Name name, int n, int n2, long l) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(n);
        DClass.check(n2);
        TTL.check(l);
        return Record.getEmptyRecord(name, n, n2, l, false);
    }

    public static Record newRecord(Name name, int n, int n2) {
        return Record.newRecord(name, n, n2, 0L);
    }

    static Record fromWire(DNSInput dNSInput, int n, boolean bl) throws IOException {
        Name name = new Name(dNSInput);
        int n2 = dNSInput.readU16();
        int n3 = dNSInput.readU16();
        if (n == 0) {
            return Record.newRecord(name, n2, n3);
        }
        long l = dNSInput.readU32();
        int n4 = dNSInput.readU16();
        if (n4 == 0 && bl) {
            return Record.newRecord(name, n2, n3, l);
        }
        Record record = Record.newRecord(name, n2, n3, l, n4, dNSInput);
        return record;
    }

    static Record fromWire(DNSInput dNSInput, int n) throws IOException {
        return Record.fromWire(dNSInput, n, false);
    }

    public static Record fromWire(byte[] byArray, int n) throws IOException {
        return Record.fromWire(new DNSInput(byArray), n, false);
    }

    void toWire(DNSOutput dNSOutput, int n, Compression compression) {
        this.name.toWire(dNSOutput, compression);
        dNSOutput.writeU16(this.type);
        dNSOutput.writeU16(this.dclass);
        if (n == 0) {
            return;
        }
        dNSOutput.writeU32(this.ttl);
        int n2 = dNSOutput.current();
        dNSOutput.writeU16(0);
        this.rrToWire(dNSOutput, compression, false);
        int n3 = dNSOutput.current() - n2 - 2;
        dNSOutput.save();
        dNSOutput.jump(n2);
        dNSOutput.writeU16(n3);
        dNSOutput.restore();
    }

    public byte[] toWire(int n) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, n, null);
        return dNSOutput.toByteArray();
    }

    private void toWireCanonical(DNSOutput dNSOutput, boolean bl) {
        this.name.toWireCanonical(dNSOutput);
        dNSOutput.writeU16(this.type);
        dNSOutput.writeU16(this.dclass);
        if (bl) {
            dNSOutput.writeU32(0L);
        } else {
            dNSOutput.writeU32(this.ttl);
        }
        int n = dNSOutput.current();
        dNSOutput.writeU16(0);
        this.rrToWire(dNSOutput, null, true);
        int n2 = dNSOutput.current() - n - 2;
        dNSOutput.save();
        dNSOutput.jump(n);
        dNSOutput.writeU16(n2);
        dNSOutput.restore();
    }

    private byte[] toWireCanonical(boolean bl) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWireCanonical(dNSOutput, bl);
        return dNSOutput.toByteArray();
    }

    public byte[] toWireCanonical() {
        return this.toWireCanonical(false);
    }

    public byte[] rdataToWireCanonical() {
        DNSOutput dNSOutput = new DNSOutput();
        this.rrToWire(dNSOutput, null, true);
        return dNSOutput.toByteArray();
    }

    abstract String rrToString();

    public String rdataToString() {
        return this.rrToString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        if (stringBuffer.length() < 8) {
            stringBuffer.append("\t");
        }
        if (stringBuffer.length() < 16) {
            stringBuffer.append("\t");
        }
        stringBuffer.append("\t");
        if (Options.check("BINDTTL")) {
            stringBuffer.append(TTL.format(this.ttl));
        } else {
            stringBuffer.append(this.ttl);
        }
        stringBuffer.append("\t");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            stringBuffer.append(DClass.string(this.dclass));
            stringBuffer.append("\t");
        }
        stringBuffer.append(Type.string(this.type));
        String string = this.rrToString();
        if (!string.equals("")) {
            stringBuffer.append("\t");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    abstract void rdataFromString(Tokenizer var1, Name var2) throws IOException;

    protected static byte[] byteArrayFromString(String string) throws TextParseException {
        byte[] byArray = string.getBytes();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (byArray.length > 255) {
                throw new TextParseException("text string too long");
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl) {
                if (by >= 48 && by <= 57 && n < 3) {
                    ++n;
                    n2 *= 10;
                    if ((n2 += by - 48) > 255) {
                        throw new TextParseException("bad escape");
                    }
                    if (n < 3) continue;
                    by = (byte)n2;
                } else if (n > 0 && n < 3) {
                    throw new TextParseException("bad escape");
                }
                byteArrayOutputStream.write(by);
                bl = false;
                continue;
            }
            if (byArray[i] == 92) {
                bl = true;
                n = 0;
                n2 = 0;
                continue;
            }
            byteArrayOutputStream.write(byArray[i]);
        }
        if (n > 0 && n < 3) {
            throw new TextParseException("bad escape");
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 255) {
            throw new TextParseException("text string too long");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static String byteArrayToString(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('\"');
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 32 || n >= 127) {
                stringBuffer.append('\\');
                stringBuffer.append(byteFormat.format(n));
                continue;
            }
            if (n == 34 || n == 92) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append((char)n);
        }
        if (bl) {
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    protected static String unknownToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\# ");
        stringBuffer.append(byArray.length);
        stringBuffer.append(" ");
        stringBuffer.append(base16.toString(byArray));
        return stringBuffer.toString();
    }

    public static Record fromString(Name name, int n, int n2, long l, Tokenizer tokenizer, Name name2) throws IOException {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(n);
        DClass.check(n2);
        TTL.check(l);
        Tokenizer.Token token = tokenizer.get();
        if (token.type == 3 && token.value.equals("\\#")) {
            int n3 = tokenizer.getUInt16();
            byte[] byArray = tokenizer.getHex();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if (n3 != byArray.length) {
                throw tokenizer.exception("invalid unknown RR encoding: length mismatch");
            }
            DNSInput dNSInput = new DNSInput(byArray);
            return Record.newRecord(name, n, n2, l, n3, dNSInput);
        }
        tokenizer.unget();
        Record record = Record.getEmptyRecord(name, n, n2, l, true);
        record.rdataFromString(tokenizer, name2);
        token = tokenizer.get();
        if (token.type != 1 && token.type != 0) {
            throw tokenizer.exception("unexpected tokens at end of record");
        }
        return record;
    }

    public static Record fromString(Name name, int n, int n2, long l, String string, Name name2) throws IOException {
        return Record.fromString(name, n, n2, l, new Tokenizer(string), name2);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getRRsetType() {
        if (this.type == 46) {
            RRSIGRecord rRSIGRecord = (RRSIGRecord)this;
            return rRSIGRecord.getTypeCovered();
        }
        return this.type;
    }

    public int getDClass() {
        return this.dclass;
    }

    public long getTTL() {
        return this.ttl;
    }

    abstract void rrToWire(DNSOutput var1, Compression var2, boolean var3);

    public boolean sameRRset(Record record) {
        return this.getRRsetType() == record.getRRsetType() && this.dclass == record.dclass && this.name.equals(record.name);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Record)) {
            return false;
        }
        Record record = (Record)object;
        if (this.type != record.type || this.dclass != record.dclass || !this.name.equals(record.name)) {
            return false;
        }
        byte[] byArray = this.rdataToWireCanonical();
        byte[] byArray2 = record.rdataToWireCanonical();
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        byte[] byArray = this.toWireCanonical(true);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += (n << 3) + (byArray[i] & 0xFF);
        }
        return n;
    }

    Record cloneRecord() {
        try {
            return (Record)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    public Record withName(Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Record record = this.cloneRecord();
        record.name = name;
        return record;
    }

    Record withDClass(int n, long l) {
        Record record = this.cloneRecord();
        record.dclass = n;
        record.ttl = l;
        return record;
    }

    void setTTL(long l) {
        this.ttl = l;
    }

    public int compareTo(Object object) {
        Record record = (Record)object;
        if (this == record) {
            return 0;
        }
        int n = this.name.compareTo(record.name);
        if (n != 0) {
            return n;
        }
        n = this.dclass - record.dclass;
        if (n != 0) {
            return n;
        }
        n = this.type - record.type;
        if (n != 0) {
            return n;
        }
        byte[] byArray = this.rdataToWireCanonical();
        byte[] byArray2 = record.rdataToWireCanonical();
        for (int i = 0; i < byArray.length && i < byArray2.length; ++i) {
            n = (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return byArray.length - byArray2.length;
    }

    public Name getAdditionalName() {
        return null;
    }

    static int checkU8(String string, int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("\"" + string + "\" " + n + " must be an unsigned 8 " + "bit value");
        }
        return n;
    }

    static int checkU16(String string, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("\"" + string + "\" " + n + " must be an unsigned 16 " + "bit value");
        }
        return n;
    }

    static long checkU32(String string, long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("\"" + string + "\" " + l + " must be an unsigned 32 " + "bit value");
        }
        return l;
    }

    static Name checkName(String string, Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        return name;
    }

    static {
        byteFormat.setMinimumIntegerDigits(3);
    }
}

