/*
 * Decompiled with CFR 0.152.
 */
package security.javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private String prompt;
    private String[] choices;
    private int defaultChoice;
    private boolean multipleSelectionsAllowed;
    private int[] selections;

    public ChoiceCallback(String prompt, String[] choices, int defaultChoice, boolean multipleSelectionsAllowed) {
        if (prompt == null || prompt.length() == 0 || choices == null || choices.length == 0 || defaultChoice < 0 || defaultChoice >= choices.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i] == null || choices[i].length() == 0) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.prompt = prompt;
        this.choices = choices;
        this.defaultChoice = defaultChoice;
        this.multipleSelectionsAllowed = multipleSelectionsAllowed;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int selection) {
        this.selections = new int[1];
        this.selections[0] = selection;
    }

    public void setSelectedIndexes(int[] selections) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = selections;
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }
}

