/**
 * 
 */
package com.beem.project.beem;

import java.util.List;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

import com.beem.project.beem.service.IXMPPFacade;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.content.res.Resources;
import android.os.IBinder;
import android.os.RemoteException;
import android.widget.TextView;
import android.widget.Toast;

/**
 * @author darisk
 *
 */
public class BeemService extends Service {

    private NotificationManager notificationManager;

    private XMPPConnection connection;
    
    private IXMPPFacade.Stub bind = new IXMPPFacade.Stub() {
    
        @Override
        public List<String> getContactList() throws RemoteException {
    	// TODO Auto-generated method stub
    	return null;
        }
    };
    
    /* (non-Javadoc)
     * @see android.app.Service#onBind(android.content.Intent)
     */
    @Override
    public IBinder onBind(Intent arg0) {
	// TODO Auto-generated method stub
	return null;
    }
    
    private void showBasicNotification(int stringResource) {
	String text = (String) getText(stringResource);
	Notification notif = new Notification(R.drawable.logo, text, System.currentTimeMillis());
	notif.defaults = Notification.DEFAULT_ALL;
	notif.setLatestEventInfo(this, text, text, PendingIntent.getActivity(this, 0, new Intent(),0));
	notificationManager.notify(stringResource, notif);
	Toast toast = Toast.makeText(this, R.string.BeemServiceCreated, Toast.LENGTH_LONG);
	toast.show();
	
    }
    
    public void onCreate(){
	super.onCreate();
	connection = new XMPPConnection("10.224.13.6"); // address du pc host de l'emulateur
	try {
	    connection.connect();
	    connection.login("bart", "bart");
	    notificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
	    showBasicNotification(R.string.BeemServiceCreated);
	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    Toast toast = Toast.makeText(this, "ERREUR " + e.getMessage(), Toast.LENGTH_LONG);
	    toast.show();
	    e.printStackTrace();
	}
	
    }
    
    public void onDestroy() {
	showBasicNotification(R.string.BeemServiceDestroyed); 
    }

}
