/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;

public class EventElement
implements EmbeddedPacketExtension {
    private EventElementType type;
    private NodeExtension ext;

    public EventElement(EventElementType eventElementType, NodeExtension nodeExtension) {
        this.type = eventElementType;
        this.ext = nodeExtension;
    }

    public EventElementType getEventType() {
        return this.type;
    }

    @Override
    public List<PacketExtension> getExtensions() {
        return Arrays.asList(this.getEvent());
    }

    public NodeExtension getEvent() {
        return this.ext;
    }

    @Override
    public String getElementName() {
        return "event";
    }

    @Override
    public String getNamespace() {
        return PubSubNamespace.EVENT.getXmlns();
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder("<event xmlns='" + PubSubNamespace.EVENT.getXmlns() + "'>");
        stringBuilder.append(this.ext.toXML());
        stringBuilder.append("</event>");
        return stringBuilder.toString();
    }
}

