package com.beem.project.beem.ui;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

import com.beem.project.beem.R;
import com.beem.project.beem.utils.BeemBroadcastReceiver;

/**
 * This class represents an activity which allows the user to change his account or proxy parameters.
 */
public class Settings extends PreferenceActivity {

    private static final Intent SERVICE_INTENT = new Intent();
    private SettingsBroadcastReceiver mReceiver;

    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }

    /**
     * Constructor.
     */
    public Settings() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	addPreferencesFromResource(R.layout.preferences);
	mReceiver = new SettingsBroadcastReceiver();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onPause() {
	super.onPause();
	this.unregisterReceiver(mReceiver);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onResume() {
	super.onResume();
	this.registerReceiver(mReceiver, new IntentFilter(BeemBroadcastReceiver.BEEM_CONNECTION_CLOSED));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onStop() {
	super.onStop();
	SharedPreferences settings = getPreferenceManager().getSharedPreferences();
	settings.edit().putBoolean(
	    "PreferenceIsConfigured",
	    !"".equals(settings.getString("settings_key_account_username", ""))
		|| !"".equals(settings.getString("settings_key_account_password", ""))).commit();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
	MenuInflater mInflater = getMenuInflater();
	mInflater.inflate(R.menu.edit_settings, menu);
	return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
	Intent i = null;
	switch (item.getItemId()) {
	    case R.id.settings_menu_create_account:
		i = new Intent(this, CreateAccount.class);
		startActivity(i);
		return true;
	    case R.id.settings_menu_login:
		setResult(RESULT_OK);
		SharedPreferences settings = getPreferenceManager().getSharedPreferences();
		settings.edit().putBoolean(
		    "PreferenceIsConfigured",
		    !"".equals(settings.getString("settings_key_account_username", ""))
			|| !"".equals(settings.getString("settings_key_account_password", ""))).commit();
		this.stopService(SERVICE_INTENT);
		finish();
		return true;
	    case R.id.settings_menu_privacy_lists:
		/*
		 * i = new Intent(this, PrivacyList.class); startActivity(i);
		 */
		return true;
	    default:
		return false;
	}
    }

    /**
     * disconnect Broadcast receiver.
     */
    private class SettingsBroadcastReceiver extends BroadcastReceiver {
	/**
	 * Constructor.
	 */
	public SettingsBroadcastReceiver() {
	}

	@Override
	public void onReceive(Context context, Intent intent) {
	    Settings.this.setResult(RESULT_CANCELED);
	}
    }
}
