package com.beem.project.beem.jingle;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/**
 * Manage microphone RTP session.
 * @author nikita
 */
public class MicrophoneRTPSession extends JingleMediaSession {

    private RTPTransmitter mTransmitter;
    private RTPReceiver mReceiver;

    /**
     * constructor.
     * @param payloadType the payload typ used
     * @param remote the remote transport info
     * @param local the local tranport info
     * @param mediaLocator don't know
     * @param jingleSession the current jingle session
     */
    public MicrophoneRTPSession(final PayloadType payloadType, final TransportCandidate remote,
	final TransportCandidate local, final String mediaLocator, final  JingleSession jingleSession) {
	super(payloadType, remote, local, mediaLocator, jingleSession);

	// TODO le transmitter ne devrait peut etre pas etre init ici, c'est peut etre encore un peu tot, a voir.
	mTransmitter = new PCMTransmitter(remote.getIp(), getRemote().getPort());
	//mReceiver = new MicroRTPReceiver(getLocal().getPort());
    }

    @Override
    public void initialize() {
	// TODO Auto-generated method stub

    }

    @Override
    public void setTrasmit(boolean active) {
    }

    @Override
    public void startReceive() {

    }

    @Override
    public void startTrasmit() {

    }

    @Override
    public void stopReceive() {
	if (mReceiver != null) {
	    mReceiver.stop();
	}
    }

    @Override
    public void stopTrasmit() {
	if (mTransmitter != null) {
	    mTransmitter.stop();
	}
    }
}
