package com.beem.project.beem.jingle;

import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;

/**
 * Transmit Microphone data through RTP.
 * @author nikita
 */
public class PCMTransmitter extends RTPTransmitter {

    /**
     * Constructor.
     * @param remoteIP destinataire ip.
     * @param port destinataire port.
     */
    public PCMTransmitter(final String remoteIP, final int port) {
	super(remoteIP, port);
    }

    @Override
    void start() {
	AudioRecord audRec = new AudioRecord(MediaRecorder.AudioSource.DEFAULT, 8000,
	    AudioFormat.CHANNEL_CONFIGURATION_MONO, AudioFormat.ENCODING_PCM_8BIT, AudioRecord.getMinBufferSize(8000,
		AudioFormat.CHANNEL_CONFIGURATION_MONO, AudioFormat.ENCODING_PCM_8BIT));
	byte[] audioData = new byte[1024];
	int byteReaded = 0;
	while (!mKillme) {
	    byteReaded = audRec.read(audioData, byteReaded, 1024);
	    System.out.println("readed " + byteReaded);
	    mRtpSession.sendData(audioData);
	}
	try {
	    Thread.sleep(200);
	} catch (InterruptedException e) {
	    e.printStackTrace();
	}
	this.mRtpSession.endSession();

    }

}
