package com.beem.project.beem.ui;

import java.util.ArrayList;

import android.app.ListActivity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnKeyListener;
import android.widget.ArrayAdapter;
import android.widget.EditText;

import com.beem.project.beem.R;

/**
 * @author barbu
 * This activity class provide the view for instant messaging
 * after selecting a correspondant.
 */

public class SendIM extends ListActivity implements OnClickListener, OnKeyListener {
    private EditText			mToSend;
    private ArrayList<String>		mMessages = new ArrayList<String>();
    private ArrayAdapter<String>	mAdapter;
    private SendIMDialogSmiley		mSmyDialog;
    private SharedPreferences mSet;

    /**
     * Constructor.
     */
    public SendIM() {
	super();
    }

    /**
     * Overload of onCreate() Activity inherited function
     */
    @Override
    public void onCreate(Bundle saveBundle) {
	super.onCreate(saveBundle);
	setContentView(R.layout.sendim);
	mToSend = (EditText) findViewById(R.id.userText);
	mSet = getSharedPreferences("lol", MODE_PRIVATE);
	mSmyDialog = new SendIMDialogSmiley(this, mSet);

	mAdapter = new ArrayAdapter<String>(this, R.layout.messagelist, mMessages);
	setListAdapter(mAdapter);

	mToSend.setOnClickListener(this);
	mToSend.setOnKeyListener(this);
    }

    /**
     * Abstract method inherited from OnClickListener
     */
    public void onClick(View view) {
	sendText();
    }

    /**
     * This method send a message to the server over the XMPP
     * connection and display it on activity view
     * TODO : Exception si la connexion se coupe pendant la conversation
     */
    private void sendText() {
	String text = mToSend.getText().toString();
	if (!text.equals("")) {
	    /*
	     * Prepare the message to be send 
	     * */
	    /*Message msg = new Message("barbu", Message.Type.chat);*/
	    /*msg.setBody(text);*/
	    mAdapter.add("Barbu " + getString(R.string.SendIMSays) + text);
	    mToSend.setText(null);
	}
    }

    /**
     * Abstract method inherited from OnKeyListener
     */
    public boolean onKey(View v, int keyCode, KeyEvent event) {
	if (event.getAction() == KeyEvent.ACTION_DOWN) {
	    switch (keyCode) {
		case KeyEvent.KEYCODE_DPAD_CENTER:
		case KeyEvent.KEYCODE_ENTER:
		    sendText();
		    return true;
	    }
	}
	return false;
    }
    
    /**
     * Callback for menu creation.
     * @param menu
     *            the menu created
     * @return true on success, false otherwise
     */
    @Override
    public final boolean onCreateOptionsMenu(Menu menu) {
	super.onCreateOptionsMenu(menu);
	MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.sendimmenu, menu);
	return true;
    }
    
    @Override
    public final boolean onOptionsItemSelected(MenuItem item) {
	switch (item.getItemId()) {
	    case R.id.sendim_smiley:
		mSmyDialog.show();
		return true;
	    default:
		return false;
	}
    }
}
