/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MetaDataUtils {
    public static Map parseMetaData(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        if (n == 2 && xmlPullParser.getName().equals("metadata") && xmlPullParser.getNamespace().equals("http://jivesoftware.com/protocol/workgroup")) {
            Hashtable hashtable = new Hashtable();
            n = xmlPullParser.nextTag();
            while (n != 3 || !xmlPullParser.getName().equals("metadata")) {
                List<String> list;
                String string = xmlPullParser.getAttributeValue(0);
                String string2 = xmlPullParser.nextText();
                if (hashtable.containsKey(string)) {
                    list = (List)hashtable.get(string);
                    list.add(string2);
                } else {
                    list = new ArrayList();
                    list.add(string2);
                    hashtable.put(string, list);
                }
                n = xmlPullParser.nextTag();
            }
            return hashtable;
        }
        return Collections.EMPTY_MAP;
    }

    public static String serializeMetaData(Map map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null && map.size() > 0) {
            stringBuilder.append("<metadata xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                if (v instanceof List) {
                    List list = (List)map.get(k);
                    for (String string : list) {
                        stringBuilder.append("<value name=\"").append(k).append("\">");
                        stringBuilder.append(StringUtils.escapeForXML(string));
                        stringBuilder.append("</value>");
                    }
                    continue;
                }
                if (!(v instanceof String)) continue;
                stringBuilder.append("<value name=\"").append(k).append("\">");
                stringBuilder.append(StringUtils.escapeForXML((String)v));
                stringBuilder.append("</value>");
            }
            stringBuilder.append("</metadata>");
        }
        return stringBuilder.toString();
    }
}

