/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class Subscription
extends NodeExtension {
    protected String jid;
    protected String id;
    protected State state;
    protected boolean configRequired = false;

    public Subscription(String subscriptionJid) {
        this(subscriptionJid, null, null, null);
    }

    public Subscription(String subscriptionJid, String nodeId) {
        this(subscriptionJid, nodeId, null, null);
    }

    public Subscription(String jid, String nodeId, String subscriptionId, State state) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
    }

    public Subscription(String jid, String nodeId, String subscriptionId, State state, boolean configRequired) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
        this.configRequired = configRequired;
    }

    public String getJid() {
        return this.jid;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConfigRequired() {
        return this.configRequired;
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder("<subscription");
        this.appendAttribute(builder, "jid", this.jid);
        if (this.getNode() != null) {
            this.appendAttribute(builder, "node", this.getNode());
        }
        if (this.id != null) {
            this.appendAttribute(builder, "subid", this.id);
        }
        if (this.state != null) {
            this.appendAttribute(builder, "subscription", this.state.toString());
        }
        builder.append("/>");
        return builder.toString();
    }

    private void appendAttribute(StringBuilder builder, String att, String value) {
        builder.append(" ");
        builder.append(att);
        builder.append("='");
        builder.append(value);
        builder.append("'");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        subscribed,
        unconfigured,
        pending,
        none;

    }
}

