/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestMD5Base;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import security.javax.security.auth.callback.NameCallback;
import security.javax.security.sasl.AuthorizeCallback;
import security.javax.security.sasl.RealmCallback;
import security.javax.security.sasl.SaslException;
import security.javax.security.sasl.SaslServer;

final class DigestMD5Server
extends DigestMD5Base
implements SaslServer {
    private static final String MY_CLASS_NAME = DigestMD5Server.class.getName();
    private static final String UTF8_DIRECTIVE = "charset=utf-8,";
    private static final String ALGORITHM_DIRECTIVE = "algorithm=md5-sess";
    private static final int NONCE_COUNT_VALUE = 1;
    private static final String UTF8_PROPERTY = "com.sun.security.sasl.digest.utf8";
    private static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    private static final String[] DIRECTIVE_KEY = new String[]{"username", "realm", "nonce", "cnonce", "nonce-count", "qop", "digest-uri", "response", "maxbuf", "charset", "cipher", "authzid", "auth-param"};
    private static final int USERNAME = 0;
    private static final int REALM = 1;
    private static final int NONCE = 2;
    private static final int CNONCE = 3;
    private static final int NONCE_COUNT = 4;
    private static final int QOP = 5;
    private static final int DIGEST_URI = 6;
    private static final int RESPONSE = 7;
    private static final int MAXBUF = 8;
    private static final int CHARSET = 9;
    private static final int CIPHER = 10;
    private static final int AUTHZID = 11;
    private static final int AUTH_PARAM = 12;
    private String specifiedQops;
    private byte[] myCiphers;
    private List<String> serverRealms = new ArrayList<String>();

    DigestMD5Server(String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        super(props, MY_CLASS_NAME, 1, String.valueOf(protocol) + "/" + serverName, cbh);
        this.useUTF8 = true;
        if (props != null) {
            String realms;
            this.specifiedQops = (String)props.get("javax.security.sasl.qop");
            if ("false".equals((String)props.get(UTF8_PROPERTY))) {
                this.useUTF8 = false;
                logger.log(Level.FINE, "DIGEST80:Server supports ISO-Latin-1");
            }
            if ((realms = (String)props.get(REALM_PROPERTY)) != null) {
                StringTokenizer parser = new StringTokenizer(realms, ", \t\n");
                int tokenCount = parser.countTokens();
                String token = null;
                int i = 0;
                while (i < tokenCount) {
                    token = parser.nextToken();
                    logger.log(Level.FINE, "DIGEST81:Server supports realm {0}", token);
                    this.serverRealms.add(token);
                    ++i;
                }
            }
        }
        String string = this.encoding = this.useUTF8 ? "UTF8" : "8859_1";
        if (this.serverRealms.size() == 0) {
            this.serverRealms.add(serverName);
        }
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response.length > 4096) {
            throw new SaslException("DIGEST-MD5: Invalid digest response length. Got:  " + response.length + " Expected < " + 4096);
        }
        switch (this.step) {
            case 1: {
                if (response.length != 0) {
                    throw new SaslException("DIGEST-MD5 must not have an initial response");
                }
                String supportedCiphers = null;
                if ((this.allQop & 4) != 0) {
                    this.myCiphers = DigestMD5Server.getPlatformCiphers();
                    StringBuffer buf = new StringBuffer();
                    int i = 0;
                    while (i < CIPHER_TOKENS.length) {
                        if (this.myCiphers[i] != 0) {
                            if (buf.length() > 0) {
                                buf.append(',');
                            }
                            buf.append(CIPHER_TOKENS[i]);
                        }
                        ++i;
                    }
                    supportedCiphers = buf.toString();
                }
                try {
                    byte[] challenge = this.generateChallenge(this.serverRealms, this.specifiedQops, supportedCiphers);
                    this.step = 3;
                    return challenge;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SaslException("DIGEST-MD5: Error encoding challenge", e);
                }
                catch (IOException e) {
                    throw new SaslException("DIGEST-MD5: Error generating challenge", e);
                }
            }
            case 3: {
                byte[] challenge;
                try {
                    try {
                        byte[][] responseVal = DigestMD5Server.parseDirectives(response, DIRECTIVE_KEY, null, 1);
                        challenge = this.validateClientResponse(responseVal);
                    }
                    catch (SaslException e) {
                        throw e;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SaslException("DIGEST-MD5: Error validating client response", e);
                    }
                }
                finally {
                    this.step = 0;
                }
                this.completed = true;
                if (this.integrity && this.privacy) {
                    this.secCtx = new DigestMD5Base.DigestPrivacy(false);
                } else if (this.integrity) {
                    this.secCtx = new DigestMD5Base.DigestIntegrity(false);
                }
                return challenge;
            }
        }
        throw new SaslException("DIGEST-MD5: Server at illegal state");
    }

    private byte[] generateChallenge(List<String> realms, String qopStr, String cipherStr) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (realms != null && i < realms.size()) {
            out.write("realm=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(out, realms.get(i).getBytes(this.encoding));
            out.write(34);
            out.write(44);
            ++i;
        }
        out.write("nonce=\"".getBytes(this.encoding));
        this.nonce = DigestMD5Server.generateNonce();
        DigestMD5Server.writeQuotedStringValue(out, this.nonce);
        out.write(34);
        out.write(44);
        if (qopStr != null) {
            out.write("qop=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(out, qopStr.getBytes(this.encoding));
            out.write(34);
            out.write(44);
        }
        if (this.recvMaxBufSize != 65536) {
            out.write(("maxbuf=\"" + this.recvMaxBufSize + "\",").getBytes(this.encoding));
        }
        if (this.useUTF8) {
            out.write(UTF8_DIRECTIVE.getBytes(this.encoding));
        }
        if (cipherStr != null) {
            out.write("cipher=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(out, cipherStr.getBytes(this.encoding));
            out.write(34);
            out.write(44);
        }
        out.write(ALGORITHM_DIRECTIVE.getBytes(this.encoding));
        return out.toByteArray();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] validateClientResponse(byte[][] responseVal) throws SaslException, UnsupportedEncodingException {
        if (responseVal[9] != null) {
            if (this.useUTF8 == false) throw new SaslException("DIGEST-MD5: digest response format violation. Incompatible charset value: " + new String(responseVal[9]));
            if (!"utf-8".equals(new String(responseVal[9], this.encoding))) {
                throw new SaslException("DIGEST-MD5: digest response format violation. Incompatible charset value: " + new String(responseVal[9]));
            }
        }
        clntMaxBufSize = responseVal[8] == null ? 65536 : Integer.parseInt(new String(responseVal[8], this.encoding));
        this.sendMaxBufSize = this.sendMaxBufSize == 0 ? clntMaxBufSize : Math.min(this.sendMaxBufSize, clntMaxBufSize);
        if (responseVal[0] == null) throw new SaslException("DIGEST-MD5: digest response format violation. Missing username.");
        username = new String(responseVal[0], this.encoding);
        DigestMD5Server.logger.log(Level.FINE, "DIGEST82:Username: {0}", username);
        this.negotiatedRealm = responseVal[1] != null ? new String(responseVal[1], this.encoding) : "";
        DigestMD5Server.logger.log(Level.FINE, "DIGEST83:Client negotiated realm: {0}", this.negotiatedRealm);
        if (!this.serverRealms.contains(this.negotiatedRealm)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Nonexistent realm: " + this.negotiatedRealm);
        }
        if (responseVal[2] == null) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Missing nonce.");
        }
        nonceFromClient = responseVal[2];
        if (!Arrays.equals(nonceFromClient, this.nonce)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched nonce.");
        }
        if (responseVal[3] == null) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Missing cnonce.");
        }
        cnonce = responseVal[3];
        if (responseVal[4] != null && 1 != Integer.parseInt(new String(responseVal[4], this.encoding), 16)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Nonce count does not match: " + new String(responseVal[4]));
        }
        this.negotiatedQop = responseVal[5] != null ? new String(responseVal[5], this.encoding) : "auth";
        DigestMD5Server.logger.log(Level.FINE, "DIGEST84:Client negotiated qop: {0}", this.negotiatedQop);
        if (this.negotiatedQop.equals("auth")) {
            cQop = 1;
        } else if (this.negotiatedQop.equals("auth-int")) {
            cQop = 2;
            this.integrity = true;
            this.rawSendSize = this.sendMaxBufSize - 16;
        } else {
            if (this.negotiatedQop.equals("auth-conf") == false) throw new SaslException("DIGEST-MD5: digest response format violation. Invalid QOP: " + this.negotiatedQop);
            cQop = 4;
            this.privacy = true;
            this.integrity = true;
            this.rawSendSize = this.sendMaxBufSize - 26;
        }
        if ((cQop & this.allQop) == 0) {
            throw new SaslException("DIGEST-MD5: server does not support  qop: " + this.negotiatedQop);
        }
        if (this.privacy) {
            v0 = this.negotiatedCipher = responseVal[10] != null ? new String(responseVal[10], this.encoding) : null;
            if (this.negotiatedCipher == null) {
                throw new SaslException("DIGEST-MD5: digest response format violation. No cipher specified.");
            }
            foundCipher = -1;
            DigestMD5Server.logger.log(Level.FINE, "DIGEST85:Client negotiated cipher: {0}", this.negotiatedCipher);
            j = 0;
            while (j < DigestMD5Server.CIPHER_TOKENS.length) {
                if (this.negotiatedCipher.equals(DigestMD5Server.CIPHER_TOKENS[j]) && this.myCiphers[j] != 0) {
                    foundCipher = j;
                    break;
                }
                ++j;
            }
            if (foundCipher == -1) {
                throw new SaslException("DIGEST-MD5: server does not support cipher: " + this.negotiatedCipher);
            }
            this.negotiatedStrength = (DigestMD5Server.CIPHER_MASKS[foundCipher] & 4) != 0 ? "high" : ((DigestMD5Server.CIPHER_MASKS[foundCipher] & 2) != 0 ? "medium" : "low");
            DigestMD5Server.logger.log(Level.FINE, "DIGEST86:Negotiated strength: {0}", this.negotiatedStrength);
        }
        v1 = digestUriFromResponse = responseVal[6] != null ? new String(responseVal[6], this.encoding) : null;
        if (digestUriFromResponse != null) {
            DigestMD5Server.logger.log(Level.FINE, "DIGEST87:digest URI: {0}", digestUriFromResponse);
        }
        if (this.digestUri.equalsIgnoreCase(digestUriFromResponse) == false) throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched URI: " + digestUriFromResponse + "; expecting: " + this.digestUri);
        this.digestUri = digestUriFromResponse;
        responseFromClient = responseVal[7];
        if (responseFromClient == null) {
            throw new SaslException("DIGEST-MD5: digest response format  violation. Missing response.");
        }
        authzidBytes = responseVal[11];
        v2 = authzidFromClient = authzidBytes != null ? new String(authzidBytes, this.encoding) : username;
        if (authzidBytes != null) {
            DigestMD5Server.logger.log(Level.FINE, "DIGEST88:Authzid: {0}", new String(authzidBytes));
        }
        try {
            rcb = new RealmCallback("DIGEST-MD5 realm: ", this.negotiatedRealm);
            ncb = new NameCallback("DIGEST-MD5 authentication ID: ", username);
            pcb = new PasswordCallback("DIGEST-MD5 password: ", false);
            this.cbh.handle(new Callback[]{rcb, ncb, pcb});
            passwd = pcb.getPassword();
            pcb.clearPassword();
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("DIGEST-MD5: Cannot perform callback to acquire password", e);
        }
        catch (IOException e) {
            throw new SaslException("DIGEST-MD5: IO error acquiring password", e);
        }
        if (passwd == null) {
            throw new SaslException("DIGEST-MD5: cannot acquire password for " + username + " in realm : " + this.negotiatedRealm);
        }
        try {
            try {
                expectedResponse = this.generateResponseValue("AUTHENTICATE", this.digestUri, this.negotiatedQop, username, this.negotiatedRealm, passwd, this.nonce, cnonce, 1, authzidBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("DIGEST-MD5: problem duplicating client response", e);
            }
            catch (IOException e) {
                throw new SaslException("DIGEST-MD5: problem duplicating client response", e);
            }
            if (!Arrays.equals(responseFromClient, expectedResponse)) {
                throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched response.");
            }
            try {
                acb = new AuthorizeCallback(username, authzidFromClient);
                this.cbh.handle(new Callback[]{acb});
                if (acb.isAuthorized() == false) throw new SaslException("DIGEST-MD5: " + username + " is not authorized to act as " + authzidFromClient);
                this.authzid = acb.getAuthorizedID();
            }
            catch (SaslException e) {
                throw e;
            }
            catch (UnsupportedCallbackException e) {
                throw new SaslException("DIGEST-MD5: Cannot perform callback to check authzid", e);
            }
            catch (IOException e) {
                throw new SaslException("DIGEST-MD5: IO error checking authzid", e);
            }
            var15_25 = this.generateResponseAuth(username, passwd, cnonce, 1, authzidBytes);
            return var15_25;
        }
        finally {
            i = 0;
            ** while (i < passwd.length)
        }
lbl-1000:
        // 1 sources

        {
            passwd[i] = '\u0000';
            ++i;
            continue;
        }
lbl114:
        // 1 sources

        return var15_25;
    }

    private byte[] generateResponseAuth(String username, char[] passwd, byte[] cnonce, int nonceCount, byte[] authzidBytes) throws SaslException {
        try {
            byte[] responseValue = this.generateResponseValue("", this.digestUri, this.negotiatedQop, username, this.negotiatedRealm, passwd, this.nonce, cnonce, nonceCount, authzidBytes);
            byte[] challenge = new byte[responseValue.length + 8];
            System.arraycopy("rspauth=".getBytes(this.encoding), 0, challenge, 0, 8);
            System.arraycopy(responseValue, 0, challenge, 8, responseValue.length);
            return challenge;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("DIGEST-MD5: problem generating response", e);
        }
        catch (IOException e) {
            throw new SaslException("DIGEST-MD5: problem generating response", e);
        }
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("DIGEST-MD5 server negotiation not complete");
    }
}

