/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.collections.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatManager {
    private static String prefix = StringUtils.randomString(5);
    private static long id = 0L;
    private Map<String, Chat> threadChats = new ReferenceMap<String, Chat>(0, 2);
    private Map<String, Chat> jidChats = new ReferenceMap<String, Chat>(0, 2);
    private Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private Map<PacketInterceptor, PacketFilter> interceptors = new WeakHashMap<PacketInterceptor, PacketFilter>();
    private XMPPConnection connection;

    private static synchronized String nextID() {
        return prefix + Long.toString(id++);
    }

    ChatManager(XMPPConnection connection) {
        this.connection = connection;
        PacketFilter filter = new PacketFilter(){

            public boolean accept(Packet packet) {
                if (!(packet instanceof Message)) {
                    return false;
                }
                Message.Type messageType = ((Message)packet).getType();
                return messageType != Message.Type.groupchat && messageType != Message.Type.headline;
            }
        };
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Chat chat;
                Message message = (Message)packet;
                if (message.getThread() == null) {
                    chat = ChatManager.this.getUserChat(StringUtils.parseBareAddress(message.getFrom()));
                } else {
                    chat = ChatManager.this.getThreadChat(message.getThread());
                    if (chat == null) {
                        chat = ChatManager.this.getUserChat(StringUtils.parseBareAddress(message.getFrom()));
                    }
                }
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                ChatManager.this.deliverMessage(chat, message);
            }
        }, filter);
    }

    public Chat createChat(String userJID, MessageListener listener) {
        String threadID;
        while (this.threadChats.get(threadID = ChatManager.nextID()) != null) {
        }
        return this.createChat(userJID, threadID, listener);
    }

    public Chat createChat(String userJID, String thread, MessageListener listener) {
        Chat chat;
        if (thread == null) {
            thread = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(thread)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(userJID, thread, true);
        chat.addMessageListener(listener);
        return chat;
    }

    private Chat createChat(String userJID, String threadID, boolean createdLocally) {
        Chat chat = new Chat(this, userJID, threadID);
        this.threadChats.put(threadID, chat);
        this.jidChats.put(userJID, chat);
        for (ChatManagerListener listener : this.chatManagerListeners) {
            listener.chatCreated(chat, createdLocally);
        }
        return chat;
    }

    private Chat createChat(Message message) {
        String threadID = message.getThread();
        if (threadID == null) {
            threadID = ChatManager.nextID();
        }
        String userJID = message.getFrom();
        return this.createChat(userJID, threadID, false);
    }

    private Chat getUserChat(String userJID) {
        return this.jidChats.get(userJID);
    }

    public Chat getThreadChat(String thread) {
        return this.threadChats.get(thread);
    }

    public void addChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.add(listener);
    }

    public void removeChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.remove(listener);
    }

    public Collection<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableCollection(this.chatManagerListeners);
    }

    private void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) {
        for (Map.Entry<PacketInterceptor, PacketFilter> interceptor : this.interceptors.entrySet()) {
            PacketFilter filter = interceptor.getValue();
            if (filter == null || !filter.accept(message)) continue;
            interceptor.getKey().interceptPacket(message);
        }
        if (message.getFrom() == null) {
            message.setFrom(this.connection.getUser());
        }
        this.connection.sendPacket(message);
    }

    PacketCollector createPacketCollector(Chat chat) {
        return this.connection.createPacketCollector(new AndFilter(new ThreadFilter(chat.getThreadID()), new FromContainsFilter(chat.getParticipant())));
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor) {
        this.addOutgoingMessageInterceptor(packetInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor, PacketFilter filter) {
        if (packetInterceptor != null) {
            this.interceptors.put(packetInterceptor, filter);
        }
    }
}

