/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.packet.MUCUser;
import org.xmlpull.v1.XmlPullParser;

public class MUCUserProvider
implements PacketExtensionProvider {
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        MUCUser mucUser = new MUCUser();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("invite")) {
                    mucUser.setInvite(this.parseInvite(parser));
                }
                if (parser.getName().equals("item")) {
                    mucUser.setItem(this.parseItem(parser));
                }
                if (parser.getName().equals("password")) {
                    mucUser.setPassword(parser.nextText());
                }
                if (parser.getName().equals("status")) {
                    mucUser.setStatus(new MUCUser.Status(parser.getAttributeValue("", "code")));
                }
                if (parser.getName().equals("decline")) {
                    mucUser.setDecline(this.parseDecline(parser));
                }
                if (!parser.getName().equals("destroy")) continue;
                mucUser.setDestroy(this.parseDestroy(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("x")) continue;
            done = true;
        }
        return mucUser;
    }

    private MUCUser.Item parseItem(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCUser.Item item = new MUCUser.Item(parser.getAttributeValue("", "affiliation"), parser.getAttributeValue("", "role"));
        item.setNick(parser.getAttributeValue("", "nick"));
        item.setJid(parser.getAttributeValue("", "jid"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("actor")) {
                    item.setActor(parser.getAttributeValue("", "jid"));
                }
                if (!parser.getName().equals("reason")) continue;
                item.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("item")) continue;
            done = true;
        }
        return item;
    }

    private MUCUser.Invite parseInvite(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setFrom(parser.getAttributeValue("", "from"));
        invite.setTo(parser.getAttributeValue("", "to"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                invite.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("invite")) continue;
            done = true;
        }
        return invite;
    }

    private MUCUser.Decline parseDecline(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setFrom(parser.getAttributeValue("", "from"));
        decline.setTo(parser.getAttributeValue("", "to"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                decline.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("decline")) continue;
            done = true;
        }
        return decline;
    }

    private MUCUser.Destroy parseDestroy(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCUser.Destroy destroy = new MUCUser.Destroy();
        destroy.setJid(parser.getAttributeValue("", "jid"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                destroy.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("destroy")) continue;
            done = true;
        }
        return destroy;
    }
}

