package com.beem.project.beem.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.widget.Toast;

import com.beem.project.beem.ui.Login;

/**
 * Manage broadcast disconnect intent.
 * @author nikita
 */
public class BeemBroadcastReceiver extends BroadcastReceiver {

    public static final String BEEM_CONNECTION_CLOSED = "BeemConnectionClosed";
    private ServiceConnection mService;
    private boolean mIsBinded;
    
    /**
     * constructor.
     */
    public BeemBroadcastReceiver(ServiceConnection service) {
	mService = service;
	mIsBinded = false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onReceive(Context context, Intent intent) {
	context.unbindService(mService);
	mIsBinded = false;
	context.startActivity(new Intent(context, Login.class));
	CharSequence message = intent.getCharSequenceExtra("message");	
	Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }
    
    public void setBinded() {
	mIsBinded = true;
    }

    public boolean isBinded() {
	return mIsBinded;
    }
}
