/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import com.sun.security.sasl.CramMD5Client;
import com.sun.security.sasl.ExternalClient;
import com.sun.security.sasl.PlainClient;
import com.sun.security.sasl.util.PolicyUtils;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import security.javax.security.auth.callback.NameCallback;
import security.javax.security.sasl.SaslClient;
import security.javax.security.sasl.SaslClientFactory;
import security.javax.security.sasl.SaslException;

public final class ClientFactoryImpl
implements SaslClientFactory {
    private static final String[] myMechs = new String[]{"EXTERNAL", "CRAM-MD5", "PLAIN"};
    private static final int[] mechPolicies = new int[]{7, 17, 16};
    private static final int EXTERNAL = 0;
    private static final int CRAMMD5 = 1;
    private static final int PLAIN = 2;

    @Override
    public SaslClient createSaslClient(String[] mechs, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        int i = 0;
        while (i < mechs.length) {
            if (mechs[i].equals(myMechs[0]) && PolicyUtils.checkPolicy(mechPolicies[0], props)) {
                return new ExternalClient(authorizationId);
            }
            if (mechs[i].equals(myMechs[1]) && PolicyUtils.checkPolicy(mechPolicies[1], props)) {
                Object[] uinfo = this.getUserInfo("CRAM-MD5", authorizationId, cbh);
                return new CramMD5Client((String)uinfo[0], (byte[])uinfo[1]);
            }
            if (mechs[i].equals(myMechs[2]) && PolicyUtils.checkPolicy(mechPolicies[2], props)) {
                Object[] uinfo = this.getUserInfo("PLAIN", authorizationId, cbh);
                return new PlainClient(authorizationId, (String)uinfo[0], (byte[])uinfo[1]);
            }
            ++i;
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, props);
    }

    private Object[] getUserInfo(String prefix, String authorizationId, CallbackHandler cbh) throws SaslException {
        if (cbh == null) {
            throw new SaslException("Callback handler to get username/password required");
        }
        try {
            byte[] bytepw;
            String userPrompt = String.valueOf(prefix) + " authentication id: ";
            String passwdPrompt = String.valueOf(prefix) + " password: ";
            NameCallback ncb = authorizationId == null ? new NameCallback(userPrompt) : new NameCallback(userPrompt, authorizationId);
            PasswordCallback pcb = new PasswordCallback(passwdPrompt, false);
            cbh.handle(new Callback[]{ncb, pcb});
            char[] pw = pcb.getPassword();
            if (pw != null) {
                bytepw = new String(pw).getBytes("UTF8");
                pcb.clearPassword();
            } else {
                bytepw = null;
            }
            String authId = ncb.getName();
            return new Object[]{authId, bytepw};
        }
        catch (IOException e) {
            throw new SaslException("Cannot get password", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Cannot get userid/password", e);
        }
    }
}

