/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class TSIGRecord
extends Record {
    private static final long serialVersionUID = -88820909016649306L;
    private Name alg;
    private Date timeSigned;
    private int fudge;
    private byte[] signature;
    private int originalID;
    private int error;
    private byte[] other;

    TSIGRecord() {
    }

    Record getObject() {
        return new TSIGRecord();
    }

    public TSIGRecord(Name name, int n, long l, Name name2, Date date, int n2, byte[] byArray, int n3, int n4, byte[] byArray2) {
        super(name, 250, n, l);
        this.alg = TSIGRecord.checkName("alg", name2);
        this.timeSigned = date;
        this.fudge = TSIGRecord.checkU16("fudge", n2);
        this.signature = byArray;
        this.originalID = TSIGRecord.checkU16("originalID", n3);
        this.error = TSIGRecord.checkU16("error", n4);
        this.other = byArray2;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.alg = new Name(dNSInput);
        long l = dNSInput.readU16();
        long l2 = dNSInput.readU32();
        long l3 = (l << 32) + l2;
        this.timeSigned = new Date(l3 * 1000L);
        this.fudge = dNSInput.readU16();
        int n = dNSInput.readU16();
        this.signature = dNSInput.readByteArray(n);
        this.originalID = dNSInput.readU16();
        this.error = dNSInput.readU16();
        int n2 = dNSInput.readU16();
        this.other = (byte[])(n2 > 0 ? dNSInput.readByteArray(n2) : null);
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        throw tokenizer.exception("no text format defined for TSIG");
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.alg);
        stringBuffer.append(" ");
        if (Options.check("multiline")) {
            stringBuffer.append("(\n\t");
        }
        stringBuffer.append(this.timeSigned.getTime() / 1000L);
        stringBuffer.append(" ");
        stringBuffer.append(this.fudge);
        stringBuffer.append(" ");
        stringBuffer.append(this.signature.length);
        if (Options.check("multiline")) {
            stringBuffer.append("\n");
            stringBuffer.append(base64.formatString(this.signature, 64, "\t", false));
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(base64.toString(this.signature));
        }
        stringBuffer.append(" ");
        stringBuffer.append(Rcode.TSIGstring(this.error));
        stringBuffer.append(" ");
        if (this.other == null) {
            stringBuffer.append(0);
        } else {
            stringBuffer.append(this.other.length);
            if (Options.check("multiline")) {
                stringBuffer.append("\n\n\n\t");
            } else {
                stringBuffer.append(" ");
            }
            if (this.error == 18) {
                if (this.other.length != 6) {
                    stringBuffer.append("<invalid BADTIME other data>");
                } else {
                    long l = ((long)(this.other[0] & 0xFF) << 40) + ((long)(this.other[1] & 0xFF) << 32) + (long)((this.other[2] & 0xFF) << 24) + (long)((this.other[3] & 0xFF) << 16) + (long)((this.other[4] & 0xFF) << 8) + (long)(this.other[5] & 0xFF);
                    stringBuffer.append("<server time: ");
                    stringBuffer.append(new Date(l * 1000L));
                    stringBuffer.append(">");
                }
            } else {
                stringBuffer.append("<");
                stringBuffer.append(base64.toString(this.other));
                stringBuffer.append(">");
            }
        }
        if (Options.check("multiline")) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFudge() {
        return this.fudge;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getOther() {
        return this.other;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.alg.toWire(dNSOutput, null, bl);
        long l = this.timeSigned.getTime() / 1000L;
        int n = (int)(l >> 32);
        long l2 = l & 0xFFFFFFFFL;
        dNSOutput.writeU16(n);
        dNSOutput.writeU32(l2);
        dNSOutput.writeU16(this.fudge);
        dNSOutput.writeU16(this.signature.length);
        dNSOutput.writeByteArray(this.signature);
        dNSOutput.writeU16(this.originalID);
        dNSOutput.writeU16(this.error);
        if (this.other != null) {
            dNSOutput.writeU16(this.other.length);
            dNSOutput.writeByteArray(this.other);
        } else {
            dNSOutput.writeU16(0);
        }
    }
}

